/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.TileConjured;
import vazkii.psi.common.spell.trick.block.PieceTrickPlaceBlock;

public class PieceTrickConjureBlockSequence
extends PieceTrick {
    SpellParam position;
    SpellParam target;
    SpellParam maxBlocks;
    SpellParam time;

    public PieceTrickConjureBlockSequence(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", 4117034, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", 0xD22A2A, false, true);
        this.addParam(this.maxBlocks);
        this.time = new ParamNumber("psi.spellparam.time", 7678674, true, false);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double maxBlocksVal = (Double)this.getParamEvaluation(this.maxBlocks);
        if (maxBlocksVal == null || maxBlocksVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 15.0));
        meta.addStat(EnumSpellStat.COST, (int)(maxBlocksVal * 20.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Vector3 targetVal = (Vector3)this.getParamValue(context, this.target);
        Double maxBlocksVal = (Double)this.getParamValue(context, this.maxBlocks);
        Double timeVal = (Double)this.getParamValue(context, this.time);
        int maxBlocksInt = maxBlocksVal.intValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        int len = (int)targetVal.mag();
        Vector3 targetNorm = targetVal.copy().normalize();
        ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
        for (int i = 0; i < Math.min(len, maxBlocksInt); ++i) {
            IBlockState state;
            Vector3 blockVec = positionVal.copy().add(targetNorm.copy().multiply(i));
            if (!context.isInRadius(blockVec)) {
                throw new SpellRuntimeException("psi.spellerror.outsideradius");
            }
            BlockPos pos = new BlockPos(blockVec.x, blockVec.y, blockVec.z);
            if (!context.caster.field_70170_p.func_175660_a(context.caster, pos) || (state = context.caster.field_70170_p.func_180495_p(pos)).func_177230_c() == ModBlocks.conjured) continue;
            PieceTrickPlaceBlock.placeBlock(context.caster, context.caster.field_70170_p, pos, context.getTargetSlot(), false, true);
            state = context.caster.field_70170_p.func_180495_p(pos);
            if (context.caster.field_70170_p.field_72995_K || state.func_177230_c() != ModBlocks.conjured) continue;
            context.caster.field_70170_p.func_175656_a(pos, this.messWithState(state));
            TileConjured tile = (TileConjured)context.caster.field_70170_p.func_175625_s(pos);
            if (timeVal != null && timeVal.intValue() > 0) {
                int val;
                tile.time = val = timeVal.intValue();
            }
            if (cad == null) continue;
            tile.colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
        }
        return null;
    }

    public IBlockState messWithState(IBlockState state) {
        return state.func_177226_a((IProperty)BlockConjured.SOLID, (Comparable)Boolean.valueOf(true));
    }
}

