/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.core.sync.GuiBridge;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.networking.TileWireless;
import appeng.util.Platform;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWireless
extends AEBaseTileBlock
implements ICustomCollision {
    public static final PropertyEnum<State> STATE = PropertyEnum.func_177709_a((String)"state", State.class);

    public BlockWireless() {
        super(AEGlassMaterial.INSTANCE);
        this.setTileEntity(TileWireless.class);
        this.func_149713_g(0);
        this.setFullSize(false);
        this.setOpaque(false);
        this.func_180632_j(this.func_176223_P().func_177226_a(STATE, (Comparable)((Object)State.OFF)));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        State teState = State.OFF;
        TileWireless te = (TileWireless)this.getTileEntity(worldIn, pos);
        if (te != null) {
            if (te.isActive()) {
                teState = State.HAS_CHANNEL;
            } else if (te.isPowered()) {
                teState = State.ON;
            }
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a(STATE, (Comparable)((Object)teState));
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{STATE};
    }

    @Override
    public boolean func_180639_a(World w, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileWireless tg = (TileWireless)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null && !player.func_70093_af()) {
            if (Platform.isServer()) {
                Platform.openGUI(player, tg, AEPartLocation.fromFacing(side), GuiBridge.GUI_WIRELESS);
            }
            return true;
        }
        return super.func_180639_a(w, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity thePlayer, boolean b) {
        TileWireless tile = (TileWireless)this.getTileEntity((IBlockAccess)w, pos);
        if (tile != null) {
            EnumFacing forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 1.0;
                    minY = 0.3125;
                    break;
                }
                case EAST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 0.6875;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 1.0;
                    minZ = 0.3125;
                    break;
                }
                case SOUTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 0.6875;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 0.6875;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 1.0;
                    minX = 0.3125;
                    break;
                }
            }
            return Collections.singletonList(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        TileWireless tile = (TileWireless)this.getTileEntity((IBlockAccess)w, pos);
        if (tile != null) {
            EnumFacing forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 1.0;
                    minY = 0.3125;
                    break;
                }
                case EAST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 0.6875;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 1.0;
                    minZ = 0.3125;
                    break;
                }
                case SOUTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 0.6875;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 0.6875;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 1.0;
                    minX = 0.3125;
                    break;
                }
            }
            out.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        } else {
            out.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    static enum State implements IStringSerializable
    {
        OFF,
        ON,
        HAS_CHANNEL;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

