/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.ColorApplicatorBakedModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ColorApplicatorModel
implements IModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "item/color_applicator_colored");
    private static final ResourceLocation TEXTURE_DARK = new ResourceLocation("appliedenergistics2", "items/color_applicator_tip_dark");
    private static final ResourceLocation TEXTURE_MEDIUM = new ResourceLocation("appliedenergistics2", "items/color_applicator_tip_medium");
    private static final ResourceLocation TEXTURE_BRIGHT = new ResourceLocation("appliedenergistics2", "items/color_applicator_tip_bright");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(MODEL_BASE);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)TEXTURE_DARK, (Object)TEXTURE_MEDIUM, (Object)TEXTURE_BRIGHT);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseModel = this.getBaseModel(state, format, bakedTextureGetter);
        TextureAtlasSprite texDark = (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_DARK);
        TextureAtlasSprite texMedium = (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_MEDIUM);
        TextureAtlasSprite texBright = (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_BRIGHT);
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new ColorApplicatorBakedModel(baseModel, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, texDark, texMedium, texBright);
    }

    private IBakedModel getBaseModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE).bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

