/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.IAppEngApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.features.IRegistryContainer;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IStorageHelper;
import appeng.api.util.AEPartLocation;
import appeng.core.ApiDefinitions;
import appeng.core.api.ApiPart;
import appeng.core.api.ApiStorage;
import appeng.core.features.registries.PartModels;
import appeng.core.features.registries.RegistryContainer;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import appeng.util.Platform;

public final class Api
implements IAppEngApi {
    public static final Api INSTANCE = new Api();
    private final ApiPart partHelper;
    private final IRegistryContainer registryContainer;
    private final IStorageHelper storageHelper = new ApiStorage();
    private final ApiDefinitions definitions;

    private Api() {
        this.registryContainer = new RegistryContainer();
        this.partHelper = new ApiPart();
        this.definitions = new ApiDefinitions((PartModels)this.registryContainer.partModels());
    }

    @Override
    public IRegistryContainer registries() {
        return this.registryContainer;
    }

    @Override
    public IStorageHelper storage() {
        return this.storageHelper;
    }

    @Override
    public ApiPart partHelper() {
        return this.partHelper;
    }

    @Override
    public ApiDefinitions definitions() {
        return this.definitions;
    }

    @Override
    public IGridNode createGridNode(IGridBlock blk) {
        if (Platform.isClient()) {
            throw new IllegalStateException("Grid features for " + blk + " are server side only.");
        }
        return new GridNode(blk);
    }

    @Override
    public IGridConnection createGridConnection(IGridNode a, IGridNode b) throws FailedConnection {
        return new GridConnection(a, b, AEPartLocation.INTERNAL);
    }
}

