/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ToolReplicatorCard
extends AEBaseItem {
    public EnumActionResult onItemUseFirst(ItemStack heldItem, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (Platform.isClient()) {
            return EnumActionResult.PASS;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.func_70093_af()) {
            if (world.func_175625_s(pos) instanceof IGridHost) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", x);
                tag.func_74768_a("y", y);
                tag.func_74768_a("z", z);
                tag.func_74768_a("side", side.ordinal());
                tag.func_74768_a("dimid", world.field_73011_w.getDimension());
                heldItem.func_77982_d(tag);
            } else {
                this.outputMsg((ICommandSender)player, "This is not a Grid Tile.");
            }
        } else {
            NBTTagCompound ish = heldItem.func_77978_p();
            if (ish != null) {
                int src_x = ish.func_74762_e("x");
                int src_y = ish.func_74762_e("y");
                int src_z = ish.func_74762_e("z");
                int src_side = ish.func_74762_e("side");
                int dimid = ish.func_74762_e("dimid");
                WorldServer src_w = DimensionManager.getWorld((int)dimid);
                TileEntity te = src_w.func_175625_s(new BlockPos(src_x, src_y, src_z));
                if (te instanceof IGridHost) {
                    IGridHost gh = (IGridHost)te;
                    EnumFacing sideOff = EnumFacing.field_82609_l[src_side];
                    EnumFacing currentSideOff = side;
                    IGridNode n = gh.getGridNode(AEPartLocation.fromFacing(sideOff));
                    if (n != null) {
                        IGrid g = n.getGrid();
                        if (g != null) {
                            ISpatialCache sc = (ISpatialCache)g.getCache(ISpatialCache.class);
                            if (sc.isValidRegion()) {
                                DimensionalCoord min = sc.getMin();
                                DimensionalCoord max = sc.getMax();
                                x += currentSideOff.func_82601_c();
                                y += currentSideOff.func_96559_d();
                                z += currentSideOff.func_82599_e();
                                int min_x = min.x;
                                int min_y = min.y;
                                int min_z = min.z;
                                int rel_x = min.x - src_x + x;
                                int rel_y = min.y - src_y + y;
                                int rel_z = min.z - src_z + z;
                                int scale_x = max.x - min.x;
                                int scale_y = max.y - min.y;
                                int scale_z = max.z - min.z;
                                for (int i = 1; i < scale_x; ++i) {
                                    for (int j = 1; j < scale_y; ++j) {
                                        for (int k = 1; k < scale_z; ++k) {
                                            BlockPos p = new BlockPos(min_x + i, min_y + j, min_z + k);
                                            BlockPos d = new BlockPos(i + rel_x, j + rel_y, k + rel_z);
                                            IBlockState state = src_w.func_180495_p(p);
                                            Block blk = state.func_177230_c();
                                            IBlockState prev = world.func_180495_p(d);
                                            world.func_175656_a(d, state);
                                            if (blk != null && blk.hasTileEntity(state)) {
                                                TileEntity ote = src_w.func_175625_s(p);
                                                TileEntity nte = blk.createTileEntity(world, state);
                                                NBTTagCompound data = new NBTTagCompound();
                                                ote.func_189515_b(data);
                                                nte.func_145839_a(data.func_74737_b());
                                                world.func_175690_a(d, nte);
                                            }
                                            world.func_184138_a(d, prev, state, 3);
                                        }
                                    }
                                }
                            } else {
                                this.outputMsg((ICommandSender)player, "requires valid spatial pylon setup.");
                            }
                        } else {
                            this.outputMsg((ICommandSender)player, "no grid?");
                        }
                    } else {
                        this.outputMsg((ICommandSender)player, "No grid node?");
                    }
                } else {
                    this.outputMsg((ICommandSender)player, "Src is no longer a grid block?");
                }
            } else {
                this.outputMsg((ICommandSender)player, "No Source Defined");
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void outputMsg(ICommandSender player, String string) {
        player.func_145747_a((ITextComponent)new TextComponentString(string));
    }
}

