/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.parts.IPartModel;
import appeng.core.sync.GuiBridge;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PartCraftingTerminal
extends AbstractPartTerminal {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/crafting_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/crafting_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    private final AppEngInternalInventory craftingGrid = new AppEngInternalInventory(this, 9);

    public PartCraftingTerminal(ItemStack is) {
        super(is);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.craftingGrid) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craftingGrid.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.craftingGrid.writeToNBT(data, "craftingGrid");
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.getTile().func_174877_v().func_177958_n();
            y = this.getTile().func_174877_v().func_177956_o();
            z = this.getTile().func_174877_v().func_177952_p();
        }
        if (GuiBridge.GUI_CRAFTING_TERMINAL.hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), p)) {
            return GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        return GuiBridge.GUI_ME;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

