/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.util.ICommonTile;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.IOrientable;
import appeng.core.AELog;
import appeng.core.features.IStackSrc;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.tile.TileEvent;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AEBaseTile
extends TileEntity
implements IOrientable,
ICommonTile,
ICustomNameObject {
    private static final ThreadLocal<WeakReference<AEBaseTile>> DROP_NO_ITEMS = new ThreadLocal();
    private static final Map<Class<? extends AEBaseTile>, Map<TileEventType, List<AETileEventHandler>>> HANDLERS = new HashMap<Class<? extends AEBaseTile>, Map<TileEventType, List<AETileEventHandler>>>();
    private static final Map<Class<? extends TileEntity>, IStackSrc> ITEM_STACKS = new HashMap<Class<? extends TileEntity>, IStackSrc>();
    private int renderFragment = 0;
    @Nullable
    private String customName;
    private EnumFacing forward = null;
    private EnumFacing up = null;
    private IBlockState state;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return newSate.func_177230_c() != oldState.func_177230_c();
    }

    public static void registerTileItem(Class<? extends TileEntity> c, IStackSrc wat) {
        ITEM_STACKS.put(c, wat);
    }

    public boolean dropItems() {
        WeakReference<AEBaseTile> what = DROP_NO_ITEMS.get();
        return what == null || what.get() != this;
    }

    public boolean notLoaded() {
        return !this.field_145850_b.func_175667_e(this.field_174879_c);
    }

    @Nonnull
    public TileEntity getTile() {
        return this;
    }

    @Nullable
    protected ItemStack getItemFromTile(Object obj) {
        IStackSrc src = ITEM_STACKS.get(obj.getClass());
        if (src == null) {
            return null;
        }
        return src.stack(1);
    }

    @Nonnull
    public IBlockState getBlockState() {
        if (this.state == null) {
            this.state = this.field_145850_b.func_180495_p(this.func_174877_v());
        }
        return this.state;
    }

    public void onChunkLoad() {
        if (this.func_145837_r()) {
            this.func_145829_t();
        }
    }

    public final void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.customName = data.func_74764_b("customName") ? data.func_74779_i("customName") : null;
        try {
            if (this.canBeRotated()) {
                this.forward = EnumFacing.valueOf((String)data.func_74779_i("forward"));
                this.up = EnumFacing.valueOf((String)data.func_74779_i("up"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (AETileEventHandler h : this.getHandlerListFor(TileEventType.WORLD_NBT_READ)) {
            h.readFromNBT(this, data);
        }
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        if (this.canBeRotated()) {
            data.func_74778_a("forward", this.getForward().name());
            data.func_74778_a("up", this.getUp().name());
        }
        if (this.customName != null) {
            data.func_74778_a("customName", this.customName);
        }
        for (AETileEventHandler h : this.getHandlerListFor(TileEventType.WORLD_NBT_WRITE)) {
            h.writeToNBT(this, data);
        }
        return data;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 64, this.func_189517_E_());
    }

    private boolean hasHandlerFor(TileEventType type) {
        List<AETileEventHandler> list = this.getHandlerListFor(type);
        return !list.isEmpty();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 64) {
            this.handleUpdateTag(pkt.func_148857_g());
        }
    }

    public void onChunkUnload() {
        if (!this.func_145837_r()) {
            this.func_145843_s();
        }
    }

    private NBTTagCompound writeUpdateData() {
        NBTTagCompound data = new NBTTagCompound();
        ByteBuf stream = Unpooled.buffer();
        try {
            this.writeToStream(stream);
            if (stream.readableBytes() == 0) {
                return null;
            }
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        stream.capacity(stream.readableBytes());
        data.func_74773_a("X", stream.array());
        return data;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = this.writeUpdateData();
        if (data == null) {
            return new NBTTagCompound();
        }
        data.func_74768_a("x", this.field_174879_c.func_177958_n());
        data.func_74768_a("y", this.field_174879_c.func_177956_o());
        data.func_74768_a("z", this.field_174879_c.func_177952_p());
        return data;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        ByteBuf stream = Unpooled.copiedBuffer((byte[])tag.func_74770_j("X"));
        if (this.readFromStream(stream)) {
            this.markForUpdate();
        }
    }

    private final boolean readFromStream(ByteBuf data) {
        boolean output = false;
        try {
            if (this.canBeRotated()) {
                EnumFacing old_Forward = this.forward;
                EnumFacing old_Up = this.up;
                byte orientation = data.readByte();
                this.forward = EnumFacing.field_82609_l[orientation & 7];
                this.up = EnumFacing.field_82609_l[orientation >> 3];
                output = this.forward != old_Forward || this.up != old_Up;
            }
            this.renderFragment = 100;
            for (AETileEventHandler h : this.getHandlerListFor(TileEventType.NETWORK_READ)) {
                if (!h.readFromStream(this, data)) continue;
                output = true;
            }
            if ((this.renderFragment & 1) == 1) {
                output = true;
            }
            this.renderFragment = 0;
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        return output;
    }

    public void markForUpdate() {
        if (this.renderFragment > 0) {
            this.renderFragment |= 1;
        } else if (this.field_145850_b != null) {
            AELog.blockUpdate(this.field_174879_c, this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private final void writeToStream(ByteBuf data) {
        try {
            if (this.canBeRotated()) {
                byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
                data.writeByte((int)orientation);
            }
            for (AETileEventHandler h : this.getHandlerListFor(TileEventType.NETWORK_WRITE)) {
                h.writeToStream(this, data);
            }
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Nonnull
    private List<AETileEventHandler> getHandlerListFor(TileEventType type) {
        Map<TileEventType, List<AETileEventHandler>> eventToHandlers = this.getEventToHandlers();
        List<AETileEventHandler> handlers = this.getHandlers(eventToHandlers, type);
        return handlers;
    }

    @Nonnull
    private Map<TileEventType, List<AETileEventHandler>> getEventToHandlers() {
        Class<?> clazz = this.getClass();
        Map<TileEventType, List<AETileEventHandler>> storedHandlers = HANDLERS.get(clazz);
        if (storedHandlers == null) {
            EnumMap<TileEventType, List<AETileEventHandler>> newStoredHandlers = new EnumMap<TileEventType, List<AETileEventHandler>>(TileEventType.class);
            HANDLERS.put(clazz, newStoredHandlers);
            for (Method method : clazz.getMethods()) {
                TileEvent event = method.getAnnotation(TileEvent.class);
                if (event == null) continue;
                this.addHandler(newStoredHandlers, event.value(), method);
            }
            return newStoredHandlers;
        }
        return storedHandlers;
    }

    @Nonnull
    private List<AETileEventHandler> getHandlers(Map<TileEventType, List<AETileEventHandler>> eventToHandlers, TileEventType event) {
        List<AETileEventHandler> oldHandlers = eventToHandlers.get((Object)event);
        if (oldHandlers == null) {
            LinkedList<AETileEventHandler> newHandlers = new LinkedList<AETileEventHandler>();
            eventToHandlers.put(event, newHandlers);
            return newHandlers;
        }
        return oldHandlers;
    }

    private void addHandler(Map<TileEventType, List<AETileEventHandler>> handlerSet, TileEventType value, Method m) {
        List<AETileEventHandler> list = handlerSet.get((Object)value);
        if (list == null) {
            list = new ArrayList<AETileEventHandler>();
            handlerSet.put(value, list);
        }
        list.add(new AETileEventHandler(m));
    }

    @Override
    public EnumFacing getForward() {
        if (this.forward == null) {
            return EnumFacing.NORTH;
        }
        return this.forward;
    }

    @Override
    public EnumFacing getUp() {
        if (this.up == null) {
            return EnumFacing.UP;
        }
        return this.up;
    }

    @Override
    public void setOrientation(EnumFacing inForward, EnumFacing inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.markForUpdate();
        Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
    }

    public void onPlacement(ItemStack stack, EntityPlayer player, EnumFacing side) {
        if (stack.func_77942_o()) {
            this.uploadSettings(SettingsFrom.DISMANTLE_ITEM, stack.func_77978_p());
        }
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        IInventory inv;
        IConfigManager cm;
        if (compound != null && this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.readFromNBT(compound);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            pHost.setPriority(compound.func_74762_e("priority"));
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.func_70302_i_());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.func_70302_i_(); ++x) {
                target.func_70299_a(x, tmp.func_70301_a(x));
            }
        }
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        if (this instanceof IInventory) {
            IInventory inv = (IInventory)this;
            for (int l = 0; l < inv.func_70302_i_(); ++l) {
                ItemStack is = inv.func_70301_a(l);
                if (is == null) continue;
                drops.add(is);
            }
        }
    }

    public void getNoDrops(World w, BlockPos pos, List<ItemStack> drops) {
    }

    public void onReady() {
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        IInventory inv;
        IConfigManager cm;
        NBTTagCompound output = new NBTTagCompound();
        if (this.hasCustomName()) {
            NBTTagCompound dsp = new NBTTagCompound();
            dsp.func_74778_a("Name", this.getCustomName());
            output.func_74782_a("display", (NBTBase)dsp);
        }
        if (this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.writeToNBT(output);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            output.func_74768_a("priority", pHost.getPriority());
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
        }
        return output.func_82582_d() ? null : output;
    }

    @Override
    public String getCustomName() {
        return this.hasCustomName() ? this.customName : this.getClass().getSimpleName();
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
        this.disableDrops();
    }

    public void disableDrops() {
        DROP_NO_ITEMS.set(new WeakReference<AEBaseTile>(this));
    }

    public void saveChanges() {
        super.func_70296_d();
    }

    public boolean requiresTESR() {
        return false;
    }

    public void setName(String name) {
        this.customName = name;
    }
}

