/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.tile.powersink.IExternalPowerSink;
import net.minecraftforge.energy.IEnergyStorage;

class ForgeEnergyAdapter
implements IEnergyStorage {
    private final IExternalPowerSink sink;

    ForgeEnergyAdapter(IExternalPowerSink sink) {
        this.sink = sink;
    }

    public final int receiveEnergy(int maxReceive, boolean simulate) {
        int networkDemand = (int)Math.floor(this.sink.getExternalPowerDemand(PowerUnits.RF, maxReceive));
        int used = Math.min(maxReceive, networkDemand);
        if (!simulate) {
            this.sink.injectExternalPower(PowerUnits.RF, used);
        }
        return used;
    }

    public final int getEnergyStored() {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.sink.getAECurrentPower()));
    }

    public final int getMaxEnergyStored() {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.sink.getAEMaxPower()));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

