/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IMaterials;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.worlddata.WorldData;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.worldgen.meteorite.Fallout;
import appeng.worldgen.meteorite.FalloutCopy;
import appeng.worldgen.meteorite.FalloutSand;
import appeng.worldgen.meteorite.FalloutSnow;
import appeng.worldgen.meteorite.IMeteoriteWorld;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;

public final class MeteoritePlacer {
    private static final double PRESSES_SPAWN_CHANCE = 0.7;
    private static final int SKYSTONE_SPAWN_LIMIT = 12;
    private final Collection<Block> validSpawn = new HashSet<Block>();
    private final Collection<Block> invalidSpawn = new HashSet<Block>();
    private final IBlockDefinition skyChestDefinition;
    private final IBlockDefinition skyStoneDefinition;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private double meteoriteSize = Math.random() * 6.0 + 2.0;
    private double realCrater = this.meteoriteSize * 2.0 + 5.0;
    private double squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
    private double crater = this.realCrater * this.realCrater;
    private NBTTagCompound settings;
    private Fallout type;

    public MeteoritePlacer() {
        IBlocks blocks = AEApi.instance().definitions().blocks();
        this.skyChestDefinition = blocks.skyStoneChest();
        this.skyStoneDefinition = blocks.skyStoneBlock();
        this.validSpawn.add(Blocks.field_150348_b);
        this.validSpawn.add(Blocks.field_150347_e);
        this.validSpawn.add((Block)Blocks.field_150349_c);
        this.validSpawn.add((Block)Blocks.field_150354_m);
        this.validSpawn.add(Blocks.field_150346_d);
        this.validSpawn.add(Blocks.field_150351_n);
        this.validSpawn.add(Blocks.field_150424_aL);
        this.validSpawn.add(Blocks.field_150366_p);
        this.validSpawn.add(Blocks.field_150352_o);
        this.validSpawn.add(Blocks.field_150482_ag);
        this.validSpawn.add(Blocks.field_150450_ax);
        this.validSpawn.add(Blocks.field_150405_ch);
        this.validSpawn.add(Blocks.field_150432_aD);
        this.validSpawn.add(Blocks.field_150433_aE);
        this.validSpawn.add(Blocks.field_150406_ce);
        this.skyStoneDefinition.maybeBlock().ifPresent(this.invalidSpawn::add);
        this.invalidSpawn.add(Blocks.field_150344_f);
        this.invalidSpawn.add((Block)Blocks.field_150454_av);
        this.invalidSpawn.add(Blocks.field_150411_aY);
        this.invalidSpawn.add((Block)Blocks.field_180413_ao);
        this.invalidSpawn.add((Block)Blocks.field_180410_as);
        this.invalidSpawn.add((Block)Blocks.field_180412_aq);
        this.invalidSpawn.add((Block)Blocks.field_180409_at);
        this.invalidSpawn.add((Block)Blocks.field_150454_av);
        this.invalidSpawn.add((Block)Blocks.field_180411_ar);
        this.invalidSpawn.add((Block)Blocks.field_180414_ap);
        this.invalidSpawn.add(Blocks.field_150336_V);
        this.invalidSpawn.add(Blocks.field_150435_aG);
        this.invalidSpawn.add((Block)Blocks.field_150355_j);
        this.invalidSpawn.add(Blocks.field_150364_r);
        this.invalidSpawn.add(Blocks.field_150363_s);
        this.type = new Fallout(this.putter, this.skyStoneDefinition);
    }

    boolean spawnMeteorite(IMeteoriteWorld w, NBTTagCompound meteoriteBlob) {
        this.settings = meteoriteBlob;
        int x = this.settings.func_74762_e("x");
        int y = this.settings.func_74762_e("y");
        int z = this.settings.func_74762_e("z");
        this.meteoriteSize = this.settings.func_74769_h("real_sizeOfMeteorite");
        this.realCrater = this.settings.func_74769_h("realCrater");
        this.squaredMeteoriteSize = this.settings.func_74769_h("sizeOfMeteorite");
        this.crater = this.settings.func_74769_h("crater");
        Block blk = Block.func_149729_e((int)this.settings.func_74762_e("blk"));
        if (blk == Blocks.field_150354_m) {
            this.type = new FalloutSand(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.field_150405_ch) {
            this.type = new FalloutCopy(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.field_150432_aD || blk == Blocks.field_150433_aE) {
            this.type = new FalloutSnow(w, x, y, z, this.putter, this.skyStoneDefinition);
        }
        int skyMode = this.settings.func_74762_e("skyMode");
        if (skyMode > 10) {
            this.placeCrater(w, x, y, z);
        }
        this.placeMeteorite(w, x, y, z);
        if (skyMode > 3) {
            this.decay(w, x, y, z);
        }
        w.done();
        return true;
    }

    private void placeCrater(IMeteoriteWorld w, int x, int y, int z) {
        boolean lava = this.settings.func_74767_n("lava");
        int maxY = 255;
        int minX = w.minX(x - 200);
        int maxX = w.maxX(x + 200);
        int minZ = w.minZ(z - 200);
        int maxZ = w.maxZ(z + 200);
        for (int j = y - 5; j < 255; ++j) {
            boolean changed = false;
            for (int i = minX; i < maxX; ++i) {
                for (int k = minZ; k < maxZ; ++k) {
                    double distanceFrom;
                    double dx = i - x;
                    double dz = k - z;
                    double h = (double)y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    if (!((double)j > h + (distanceFrom = dx * dx + dz * dz) * 0.02)) continue;
                    if (lava && j < y && w.getBlock(x, y - 1, z).func_176212_b((IBlockAccess)w.getWorld(), new BlockPos(i, j, k), EnumFacing.UP)) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(w, i, j, k, (Block)Blocks.field_150353_l);
                        continue;
                    }
                    changed = this.putter.put(w, i, j, k, Platform.AIR_BLOCK) || changed;
                }
            }
        }
        for (Object o : w.getWorld().func_72872_a(EntityItem.class, new AxisAlignedBB((double)w.minX(x - 30), (double)(y - 5), (double)w.minZ(z - 30), (double)w.maxX(x + 30), (double)(y + 30), (double)w.maxZ(z + 30)))) {
            Entity e = (Entity)o;
            e.func_70106_y();
        }
    }

    private void placeMeteorite(IMeteoriteWorld w, int x, int y, int z) {
        this.skyStoneDefinition.maybeBlock().ifPresent(block -> this.placeMeteoriteSkyStone(w, x, y, z, (Block)block));
        if (AEConfig.instance().isFeatureEnabled(AEFeature.SPAWN_PRESSES_IN_METEORITES)) {
            this.skyChestDefinition.maybeBlock().ifPresent(block -> this.putter.put(w, x, y, z, (Block)block));
            TileEntity te = w.getTileEntity(x, y, z);
            if (te instanceof IInventory) {
                InventoryAdaptor ap = InventoryAdaptor.getAdaptor(te, EnumFacing.UP);
                int primary = Math.max(1, (int)(Math.random() * 4.0));
                if (primary > 3) {
                    primary = 3;
                }
                for (int zz = 0; zz < primary; ++zz) {
                    boolean duplicate;
                    do {
                        duplicate = false;
                        int r = Math.random() > 0.7 ? WorldData.instance().storageData().getNextOrderedValue("presses") : (int)(Math.random() * 1000.0);
                        ItemStack toAdd = null;
                        IMaterials materials = AEApi.instance().definitions().materials();
                        switch (r % 4) {
                            case 0: {
                                toAdd = materials.calcProcessorPress().maybeStack(1).orElse(null);
                                break;
                            }
                            case 1: {
                                toAdd = materials.engProcessorPress().maybeStack(1).orElse(null);
                                break;
                            }
                            case 2: {
                                toAdd = materials.logicProcessorPress().maybeStack(1).orElse(null);
                                break;
                            }
                            case 3: {
                                toAdd = materials.siliconPress().maybeStack(1).orElse(null);
                                break;
                            }
                        }
                        if (toAdd == null) continue;
                        if (ap.simulateRemove(1, toAdd, null) == null) {
                            ap.addItems(toAdd);
                            continue;
                        }
                        duplicate = true;
                    } while (duplicate);
                }
                int secondary = Math.max(1, (int)(Math.random() * 3.0));
                block12: for (int zz = 0; zz < secondary; ++zz) {
                    switch ((int)(Math.random() * 1000.0) % 3) {
                        case 0: {
                            int amount = (int)(Math.random() * 12.0 + 1.0);
                            this.skyStoneDefinition.maybeStack(amount).ifPresent(ap::addItems);
                            continue block12;
                        }
                        case 1: {
                            LinkedList<ItemStack> possibles = new LinkedList<ItemStack>();
                            possibles.addAll(OreDictionary.getOres((String)"nuggetIron"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetCopper"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetTin"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetSilver"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetLead"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetPlatinum"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetNickel"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetAluminium"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetElectrum"));
                            possibles.add(new ItemStack(Items.field_151074_bl));
                            ItemStack nugget = (ItemStack)Platform.pickRandom(possibles);
                            if (nugget == null) continue block12;
                            nugget = nugget.func_77946_l();
                            nugget.field_77994_a = (int)(Math.random() * 12.0) + 1;
                            ap.addItems(nugget);
                        }
                    }
                }
            }
        }
    }

    private void placeMeteoriteSkyStone(IMeteoriteWorld w, int x, int y, int z, Block block) {
        int meteorXLength = w.minX(x - 8);
        int meteorXHeight = w.maxX(x + 8);
        int meteorZLength = w.minZ(z - 8);
        int meteorZHeight = w.maxZ(z + 8);
        for (int i = meteorXLength; i < meteorXHeight; ++i) {
            for (int j = y - 8; j < y + 8; ++j) {
                for (int k = meteorZLength; k < meteorZHeight; ++k) {
                    double dx = i - x;
                    double dy = j - y;
                    double dz = k - z;
                    double d = j > y ? 1.4 : 0.8;
                    if (!(dx * dx * 0.7 + dy * dy * d + dz * dz * 0.7 < this.squaredMeteoriteSize)) continue;
                    this.putter.put(w, i, j, k, block);
                }
            }
        }
    }

    private void decay(IMeteoriteWorld w, int x, int y, int z) {
        double randomShit = 0.0;
        int meteorXLength = w.minX(x - 30);
        int meteorXHeight = w.maxX(x + 30);
        int meteorZLength = w.minZ(z - 30);
        int meteorZHeight = w.maxZ(z + 30);
        for (int i = meteorXLength; i < meteorXHeight; ++i) {
            for (int k = meteorZLength; k < meteorZHeight; ++k) {
                for (int j = y - 9; j < y + 30; ++j) {
                    double dx;
                    double dz;
                    double dy;
                    Block blk_b;
                    Block blk = w.getBlock(i, j, k);
                    if (blk == Blocks.field_150353_l) continue;
                    if (blk.func_176200_f((IBlockAccess)w.getWorld(), new BlockPos(i, j, k))) {
                        blk = Platform.AIR_BLOCK;
                        blk_b = w.getBlock(i, j + 1, k);
                        if (blk_b != blk) {
                            IBlockState meta_b = w.getBlockState(i, j + 1, k);
                            w.setBlock(i, j, k, meta_b, 3);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crater)) continue;
                        double dx2 = i - x;
                        dy = j - y;
                        dz = k - z;
                        double dist = dx2 * dx2 + dy * dy + dz * dz;
                        Block xf = w.getBlock(i, j - 1, k);
                        if (xf.func_176200_f((IBlockAccess)w.getWorld(), new BlockPos(i, j - 1, k))) continue;
                        double extraRange = Math.random() * 0.6;
                        double height = this.crater * (extraRange + 0.2) - Math.abs(dist - this.crater * 1.7);
                        if (xf == blk || !(height > 0.0) || !(Math.random() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(w, i, j, k);
                        continue;
                    }
                    blk_b = w.getBlock(i, j + 1, k);
                    if (blk_b != Platform.AIR_BLOCK || !(Math.random() > 0.4) || !((dx = (double)(i - x)) * dx + (dy = (double)(j - y)) * dy + (dz = (double)(k - z)) * dz < this.crater * 1.6)) continue;
                    this.type.getRandomInset(w, i, j, k);
                }
            }
        }
    }

    double getSqDistance(int x, int z) {
        int chunkX = this.settings.func_74762_e("x") - x;
        int chunkZ = this.settings.func_74762_e("z") - z;
        return chunkX * chunkX + chunkZ * chunkZ;
    }

    public boolean spawnMeteorite(IMeteoriteWorld w, int x, int y, int z) {
        if (!w.hasNoSky()) {
            return false;
        }
        Block blk = w.getBlock(x, y, z);
        if (!this.validSpawn.contains(blk)) {
            return false;
        }
        this.settings = new NBTTagCompound();
        this.settings.func_74768_a("x", x);
        this.settings.func_74768_a("y", y);
        this.settings.func_74768_a("z", z);
        this.settings.func_74768_a("blk", Block.func_149682_b((Block)blk));
        this.settings.func_74780_a("real_sizeOfMeteorite", this.meteoriteSize);
        this.settings.func_74780_a("realCrater", this.realCrater);
        this.settings.func_74780_a("sizeOfMeteorite", this.squaredMeteoriteSize);
        this.settings.func_74780_a("crater", this.crater);
        this.settings.func_74757_a("lava", Math.random() > 0.9);
        if (blk == Blocks.field_150354_m) {
            this.type = new FalloutSand(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.field_150405_ch) {
            this.type = new FalloutCopy(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.field_150432_aD || blk == Blocks.field_150433_aE) {
            this.type = new FalloutSnow(w, x, y, z, this.putter, this.skyStoneDefinition);
        }
        int realValidBlocks = 0;
        for (int i = x - 6; i < x + 6; ++i) {
            for (int j = y - 6; j < y + 6; ++j) {
                for (int k = z - 6; k < z + 6; ++k) {
                    blk = w.getBlock(i, j, k);
                    if (!this.validSpawn.contains(blk)) continue;
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = x - 15; i < x + 15; ++i) {
            for (int j = y - 15; j < y + 15; ++j) {
                for (int k = z - 15; k < z + 15; ++k) {
                    blk = w.getBlock(i, j, k);
                    if (this.invalidSpawn.contains(blk)) {
                        return false;
                    }
                    if (!this.validSpawn.contains(blk)) continue;
                    ++validBlocks;
                }
            }
        }
        int minBLocks = 200;
        if (validBlocks > 200 && realValidBlocks > 80) {
            int j;
            int skyMode = 0;
            for (int i = x - 15; i < x + 15; ++i) {
                for (j = y - 15; j < y + 11; ++j) {
                    for (int k = z - 15; k < z + 15; ++k) {
                        if (!w.canBlockSeeTheSky(i, j, k)) continue;
                        ++skyMode;
                    }
                }
            }
            boolean solid = true;
            for (j = y - 15; j < y - 1; ++j) {
                if (w.getBlock(x, j, z) != Platform.AIR_BLOCK) continue;
                solid = false;
            }
            if (!solid) {
                skyMode = 0;
            }
            if (skyMode > 10) {
                this.placeCrater(w, x, y, z);
            }
            this.placeMeteorite(w, x, y, z);
            if (skyMode > 3) {
                this.decay(w, x, y, z);
            }
            this.settings.func_74768_a("skyMode", skyMode);
            w.done();
            WorldData.instance().spawnData().addNearByMeteorites(w.getWorld().field_73011_w.getDimension(), x >> 4, z >> 4, this.settings);
            return true;
        }
        return false;
    }

    NBTTagCompound getSettings() {
        return this.settings;
    }
}

