/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mekanism.api.IClientTicker;
import mekanism.api.gas.GasStack;
import mekanism.client.CapeBufferDownload;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.ObfuscatedNames;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.network.PacketConfiguratorState;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    public boolean hasNotified = false;
    public boolean initHoliday = false;
    public boolean preloadedSounds = false;
    public boolean lastTickUpdate;
    public boolean shouldReset = false;
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static Random rand = new Random();
    public static final String MIKE_CAPE = "https://dl.dropboxusercontent.com/s/ji06yflixnszcby/cape.png";
    public static final String DONATE_CAPE = "https://dl.dropboxusercontent.com/u/90411166/donate.png";
    public static final String AIDAN_CAPE = "https://dl.dropboxusercontent.com/u/90411166/aidan.png";
    private Map<String, CapeBufferDownload> mikeDownload = new HashMap<String, CapeBufferDownload>();
    private Map<String, CapeBufferDownload> donateDownload = new HashMap<String, CapeBufferDownload>();
    private Map<String, CapeBufferDownload> aidanDownload = new HashMap<String, CapeBufferDownload>();
    public static Set<IClientTicker> tickingSet = new HashSet<IClientTicker>();
    public static Map<EntityPlayer, TeleportData> portableTeleports = new HashMap<EntityPlayer, TeleportData>();
    public static int wheelStatus = 0;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (!this.hasNotified && ClientTickHandler.mc.field_71441_e != null && Mekanism.latestVersionNumber != null && Mekanism.recentNews != null) {
            MekanismUtils.checkForUpdates((EntityPlayer)ClientTickHandler.mc.field_71439_g);
            this.hasNotified = true;
        }
        if (!Mekanism.proxy.isPaused()) {
            Iterator<IClientTicker> iter = tickingSet.iterator();
            while (iter.hasNext()) {
                IClientTicker ticker = iter.next();
                if (ticker.needsTicks()) {
                    ticker.clientTick();
                    continue;
                }
                iter.remove();
            }
        }
        if (ClientTickHandler.mc.field_71441_e != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.mc.field_71441_e != null && ClientTickHandler.mc.field_71439_g != null && !Mekanism.proxy.isPaused()) {
            if (!(this.initHoliday && MekanismClient.ticksPassed % 1200L != 0L || ClientTickHandler.mc.field_71439_g == null)) {
                HolidayManager.check();
                this.initHoliday = true;
            }
            for (Object entityPlayer : ClientTickHandler.mc.field_71441_e.field_73010_i) {
                CapeBufferDownload download;
                if (!(entityPlayer instanceof AbstractClientPlayer)) continue;
                AbstractClientPlayer player2 = (AbstractClientPlayer)entityPlayer;
                if (StringUtils.func_76338_a((String)player2.func_70005_c_()).equals("mikeacttck")) {
                    download = this.mikeDownload.get(player2.func_70005_c_());
                    if (download == null) {
                        download = new CapeBufferDownload(player2.func_70005_c_(), MIKE_CAPE);
                        this.mikeDownload.put(player2.func_70005_c_(), download);
                        download.start();
                        continue;
                    }
                    if (!download.downloaded) continue;
                    ClientTickHandler.setCape(player2, download.getResourceLocation());
                    continue;
                }
                if (StringUtils.func_76338_a((String)player2.func_70005_c_()).equals("aidancbrady")) {
                    download = this.aidanDownload.get(player2.func_70005_c_());
                    if (download == null) {
                        download = new CapeBufferDownload(player2.func_70005_c_(), AIDAN_CAPE);
                        this.aidanDownload.put(player2.func_70005_c_(), download);
                        download.start();
                        continue;
                    }
                    if (!download.downloaded) continue;
                    ClientTickHandler.setCape(player2, download.getResourceLocation());
                    continue;
                }
                if (!Mekanism.donators.contains(StringUtils.func_76338_a((String)player2.func_70005_c_()))) continue;
                download = this.donateDownload.get(player2.func_70005_c_());
                if (download == null) {
                    download = new CapeBufferDownload(player2.func_70005_c_(), DONATE_CAPE);
                    this.donateDownload.put(player2.func_70005_c_(), download);
                    download.start();
                    continue;
                }
                if (!download.downloaded) continue;
                ClientTickHandler.setCape(player2, download.getResourceLocation());
            }
            ItemStack bootStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.FEET);
            if (bootStack != null && bootStack.func_77973_b() instanceof ItemFreeRunners) {
                ClientTickHandler.mc.field_71439_g.field_70138_W = 1.002f;
            } else if (ClientTickHandler.mc.field_71439_g.field_70138_W == 1.002f) {
                ClientTickHandler.mc.field_71439_g.field_70138_W = 0.5f;
            }
            if (Mekanism.flamethrowerActive.contains(ClientTickHandler.mc.field_71439_g.func_70005_c_()) != ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                if (ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                    Mekanism.flamethrowerActive.add(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                } else {
                    Mekanism.flamethrowerActive.remove(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                }
                Mekanism.packetHandler.sendToServer(new PacketFlamethrowerData.FlamethrowerDataMessage(PacketFlamethrowerData.FlamethrowerPacket.UPDATE, null, ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)));
            }
            if (Mekanism.jetpackOn.contains(ClientTickHandler.mc.field_71439_g.func_70005_c_()) != ClientTickHandler.isJetpackOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                if (ClientTickHandler.isJetpackOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                    Mekanism.jetpackOn.add(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                } else {
                    Mekanism.jetpackOn.remove(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                }
                Mekanism.packetHandler.sendToServer(new PacketJetpackData.JetpackDataMessage(PacketJetpackData.JetpackPacket.UPDATE, ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isJetpackOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)));
            }
            if (Mekanism.gasmaskOn.contains(ClientTickHandler.mc.field_71439_g.func_70005_c_()) != ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                if (ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g) && ClientTickHandler.mc.field_71462_r == null) {
                    Mekanism.gasmaskOn.add(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                } else {
                    Mekanism.gasmaskOn.remove(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                }
                Mekanism.packetHandler.sendToServer(new PacketScubaTankData.ScubaTankDataMessage(PacketScubaTankData.ScubaTankPacket.UPDATE, ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)));
            }
            if (MekanismConfig.client.enablePlayerSounds) {
                EntityPlayer player;
                for (String username : Mekanism.jetpackOn) {
                    player = ClientTickHandler.mc.field_71441_e.func_72924_a(username);
                    if (player == null) continue;
                    if (!SoundHandler.soundPlaying(player, SoundHandler.Channel.JETPACK)) {
                        SoundHandler.addSound(player, SoundHandler.Channel.JETPACK, MekanismConfig.client.replaceSoundsWhenResuming);
                    }
                    SoundHandler.playSound(player, SoundHandler.Channel.JETPACK);
                }
                for (String username : Mekanism.gasmaskOn) {
                    player = ClientTickHandler.mc.field_71441_e.func_72924_a(username);
                    if (player == null) continue;
                    if (!SoundHandler.soundPlaying(player, SoundHandler.Channel.GASMASK)) {
                        SoundHandler.addSound(player, SoundHandler.Channel.GASMASK, MekanismConfig.client.replaceSoundsWhenResuming);
                    }
                    SoundHandler.playSound(player, SoundHandler.Channel.GASMASK);
                }
                for (AbstractClientPlayer player2 : ClientTickHandler.mc.field_71441_e.field_73010_i) {
                    if (!ClientTickHandler.hasFlamethrower((EntityPlayer)player2)) continue;
                    if (!SoundHandler.soundPlaying((EntityPlayer)player2, SoundHandler.Channel.FLAMETHROWER)) {
                        SoundHandler.addSound((EntityPlayer)player2, SoundHandler.Channel.FLAMETHROWER, MekanismConfig.client.replaceSoundsWhenResuming);
                    }
                    SoundHandler.playSound((EntityPlayer)player2, SoundHandler.Channel.FLAMETHROWER);
                }
            }
            Iterator<Map.Entry<EntityPlayer, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<EntityPlayer, TeleportData> entry = iter.next();
                for (int i = 0; i < 100; ++i) {
                    double x = entry.getKey().field_70165_t + rand.nextDouble() - 0.5;
                    double y = entry.getKey().field_70163_u + rand.nextDouble() * 2.0 - 2.0;
                    double z = entry.getKey().field_70161_v + rand.nextDouble() - 0.5;
                    ClientTickHandler.mc.field_71441_e.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, 0.0, 1.0, 0.0, new int[0]);
                }
                if (ClientTickHandler.mc.field_71441_e.func_72820_D() != entry.getValue().teleportTime) continue;
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            if (chestStack != null && chestStack.func_77973_b() instanceof ItemJetpack) {
                MekanismClient.updateKey(ClientTickHandler.mc.field_71474_y.field_74314_A, KeySync.ASCEND);
                MekanismClient.updateKey(ClientTickHandler.mc.field_71474_y.field_74311_E, KeySync.DESCEND);
            }
            if (ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b();
                if (!ClientTickHandler.mc.field_71439_g.field_71075_bZ.field_75098_d) {
                    flamethrower.useGas(ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g());
                }
            }
            if (ClientTickHandler.isJetpackOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemJetpack jetpack = (ItemJetpack)chestStack.func_77973_b();
                if (jetpack.getMode(chestStack) == ItemJetpack.JetpackMode.NORMAL) {
                    ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.5);
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                } else if (jetpack.getMode(chestStack) == ItemJetpack.JetpackMode.HOVER) {
                    if (!ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && !ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71462_r != null) {
                        if (ClientTickHandler.mc.field_71439_g.field_70181_x > 0.0) {
                            ClientTickHandler.mc.field_71439_g.field_70181_x = Math.max(ClientTickHandler.mc.field_71439_g.field_70181_x - 0.15, 0.0);
                        } else if (ClientTickHandler.mc.field_71439_g.field_70181_x < 0.0 && !CommonPlayerTickHandler.isOnGround((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                            ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.0);
                        }
                    } else if (ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && ClientTickHandler.mc.field_71462_r == null) {
                        ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.2);
                    } else if (ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() && ClientTickHandler.mc.field_71462_r == null && !CommonPlayerTickHandler.isOnGround((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                        ClientTickHandler.mc.field_71439_g.field_70181_x = Math.max(ClientTickHandler.mc.field_71439_g.field_70181_x - 0.15, -0.2);
                    }
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                }
                jetpack.useGas(chestStack);
            }
            if (ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemScubaTank tank = (ItemScubaTank)chestStack.func_77973_b();
                int max = 300;
                tank.useGas(chestStack);
                GasStack received = tank.useGas(chestStack, 300 - ClientTickHandler.mc.field_71439_g.func_70086_ai());
                if (received != null) {
                    ClientTickHandler.mc.field_71439_g.func_70050_g(ClientTickHandler.mc.field_71439_g.func_70086_ai() + received.amount);
                }
                if (ClientTickHandler.mc.field_71439_g.func_70086_ai() == 300) {
                    for (Object obj : ClientTickHandler.mc.field_71439_g.func_70651_bq()) {
                        if (!(obj instanceof PotionEffect)) continue;
                        for (int i = 0; i < 9; ++i) {
                            ((PotionEffect)obj).func_76455_a((EntityLivingBase)ClientTickHandler.mc.field_71439_g);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (MekanismConfig.client.allowConfiguratorModeScroll && ClientTickHandler.mc.field_71439_g != null && ClientTickHandler.mc.field_71439_g.func_70093_af()) {
            ItemStack stack = ClientTickHandler.mc.field_71439_g.func_184614_ca();
            int delta = event.getDwheel();
            if (stack != null && stack.func_77973_b() instanceof ItemConfigurator && delta != 0) {
                ItemConfigurator configurator = (ItemConfigurator)stack.func_77973_b();
                RenderTickHandler.modeSwitchTimer = 100;
                int scaledDelta = (wheelStatus += event.getDwheel()) / 120;
                wheelStatus %= 120;
                int newVal = configurator.getState(stack).ordinal() + scaledDelta % ItemConfigurator.ConfiguratorMode.values().length;
                if (newVal > 0) {
                    newVal %= ItemConfigurator.ConfiguratorMode.values().length;
                } else if (newVal < 0) {
                    newVal = ItemConfigurator.ConfiguratorMode.values().length + newVal;
                }
                configurator.setState(stack, ItemConfigurator.ConfiguratorMode.values()[newVal]);
                Mekanism.packetHandler.sendToServer(new PacketConfiguratorState.ConfiguratorStateMessage(EnumHand.MAIN_HAND, configurator.getState(stack)));
                event.setCanceled(true);
            }
        }
    }

    public static void setCape(AbstractClientPlayer player, ResourceLocation cape) {
        try {
            Method m = ReflectionUtils.getPrivateMethod(AbstractClientPlayer.class, ObfuscatedNames.AbstractClientPlayer_getPlayerInfo, new Class[0]);
            Object obj = m.invoke((Object)player, new Object[0]);
            if (obj instanceof NetworkPlayerInfo) {
                NetworkPlayerInfo info = (NetworkPlayerInfo)obj;
                Map map = (Map)ReflectionUtils.getPrivateValue(info, NetworkPlayerInfo.class, ObfuscatedNames.NetworkPlayerInfo_playerTextures);
                map.put(MinecraftProfileTexture.Type.CAPE, cape);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void killDeadNetworks() {
        Iterator<IClientTicker> iter = tickingSet.iterator();
        while (iter.hasNext()) {
            if (iter.next().needsTicks()) continue;
            iter.remove();
        }
    }

    public static boolean isJetpackOn(EntityPlayer player) {
        ItemJetpack jetpack;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.jetpackOn.contains(player.func_70005_c_());
        }
        ItemStack stack = player.field_71071_by.field_70460_b[2];
        if (stack != null && !player.field_71075_bZ.field_75098_d && stack.func_77973_b() instanceof ItemJetpack && (jetpack = (ItemJetpack)stack.func_77973_b()).getGas(stack) != null) {
            if (ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && jetpack.getMode(stack) == ItemJetpack.JetpackMode.NORMAL && ClientTickHandler.mc.field_71462_r == null) {
                return true;
            }
            if (jetpack.getMode(stack) == ItemJetpack.JetpackMode.HOVER) {
                if (!ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && !ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71462_r != null) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                if (ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() && ClientTickHandler.mc.field_71462_r == null) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGasMaskOn(EntityPlayer player) {
        ItemScubaTank scubaTank;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.gasmaskOn.contains(player.func_70005_c_());
        }
        ItemStack tank = player.field_71071_by.field_70460_b[2];
        ItemStack mask = player.field_71071_by.field_70460_b[3];
        return tank != null && mask != null && tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemGasMask && (scubaTank = (ItemScubaTank)tank.func_77973_b()).getGas(tank) != null && scubaTank.getFlowing(tank);
    }

    public static boolean isFlamethrowerOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.flamethrowerActive.contains(player.func_70005_c_());
        }
        return ClientTickHandler.hasFlamethrower(player) && ClientTickHandler.mc.field_71474_y.field_74313_G.func_151470_d();
    }

    public static boolean hasFlamethrower(EntityPlayer player) {
        ItemFlamethrower flamethrower;
        return player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemFlamethrower && (flamethrower = (ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b()).getGas(player.field_71071_by.func_70448_g()) != null;
    }

    public static void portableTeleport(EntityPlayer player, EnumHand hand, Frequency freq) {
        if (MekanismConfig.general.portableTeleporterDelay == 0) {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, hand, freq));
        } else {
            portableTeleports.put(player, new TeleportData(hand, freq, ClientTickHandler.mc.field_71441_e.func_72820_D() + (long)MekanismConfig.general.portableTeleporterDelay));
        }
    }

    private static class TeleportData {
        private EnumHand hand;
        private Frequency freq;
        private long teleportTime;

        public TeleportData(EnumHand h, Frequency f, long t) {
            this.hand = h;
            this.freq = f;
            this.teleportTime = t;
        }
    }
}

