/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerElectricMachine;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElectricMachine
extends GuiMekanism {
    public TileEntityElectricMachine tileEntity;

    public GuiElectricMachine(InventoryPlayer inventory, TileEntityElectricMachine tentity) {
        super(tentity, new ContainerElectricMachine(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiUpgradeTab(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiSideConfigurationTab(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiTransporterConfigTab(this, 34, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, this.tileEntity.guiLocation, 164, 15));
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiElectricMachine.this.tileEntity.energyPerTick);
                return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(GuiElectricMachine.this.tileEntity.getMaxEnergy() - GuiElectricMachine.this.tileEntity.getEnergy()));
            }
        }, (IGuiWrapper)this, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, this.tileEntity.guiLocation, 55, 16));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.tileEntity.guiLocation, 55, 52).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, this.tileEntity.guiLocation, 111, 30));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return GuiElectricMachine.this.tileEntity.getScaledProgress();
            }
        }, this.getProgressType(), this, this.tileEntity.guiLocation, 77, 37));
    }

    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.BLUE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.tileEntity.guiLocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }
}

