/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RotaryCondensentratorRecipeCategory
extends BaseRecipeCategory {
    public IGuiHelper guiHelper;
    public IDrawable background;
    public IDrawable fluidOverlay;
    public RotaryCondensentratorRecipeWrapper tempRecipe;
    public ITickTimer timer;

    public RotaryCondensentratorRecipeCategory(IGuiHelper helper) {
        super("mekanism:gui/nei/GuiRotaryCondensentrator.png", "rotary_condensentrator", "nei.rotaryCondensentrator", null);
        this.guiHelper = helper;
        this.timer = helper.createTickTimer(20, 20, false);
        this.xOffset = 3;
        this.yOffset = 12;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 170, 71);
        this.fluidOverlay = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), 176, 40, 16, 59);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        if (this.tempRecipe.condensentrating) {
            this.drawTexturedRect(64 - this.xOffset, 39 - this.yOffset, 176, 123, 48, 8);
        } else {
            this.drawTexturedRect(64 - this.xOffset, 39 - this.yOffset, 176, 115, 48, 8);
        }
        if (this.tempRecipe.gasType != null) {
            this.displayGauge(58, 26 - this.xOffset, 14 - this.yOffset, 176, 40, 58, null, new GasStack(this.tempRecipe.gasType, 1));
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof RotaryCondensentratorRecipeWrapper) {
            this.tempRecipe = (RotaryCondensentratorRecipeWrapper)recipeWrapper;
        }
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, !this.tempRecipe.condensentrating, 134 - this.xOffset, 14 - this.yOffset, 16, 58, 1000, false, this.fluidOverlay);
        if (this.tempRecipe.condensentrating) {
            fluidStacks.set(0, (FluidStack)ingredients.getOutputs(FluidStack.class).get(0));
        } else {
            fluidStacks.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        }
    }
}

