/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class TransitRequest {
    public Map<ItemStack, Integer> itemMap = new HashMap<ItemStack, Integer>();

    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public void setItem(ItemStack stack, int slot) {
        this.itemMap.put(stack, slot);
    }

    public ItemStack getSingleStack() {
        return this.itemMap.keySet().iterator().next();
    }

    public boolean hasType(ItemStack stack) {
        for (ItemStack s : this.itemMap.keySet()) {
            if (!InventoryUtils.areItemsStackable(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static TransitRequest getFromTransport(TransporterStack stack) {
        return TransitRequest.getFromStack(stack.itemStack);
    }

    public static TransitRequest getFromStack(ItemStack stack) {
        TransitRequest ret = new TransitRequest();
        ret.setItem(stack, -1);
        return ret;
    }

    public static TransitRequest getTopStacks(TileEntity tile, EnumFacing side, int amount) {
        return TransitRequest.getTopStacks(tile, side, amount, new Finder.FirstFinder());
    }

    public static TransitRequest getTopStacks(TileEntity tile, EnumFacing side, int amount, Finder finder) {
        TransitRequest ret;
        block7: {
            block6: {
                ret = new TransitRequest();
                if (!(tile instanceof ISidedInventory)) break block6;
                ISidedInventory sidedInventory = (ISidedInventory)tile;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots == null) break block7;
                for (int get = slots.length - 1; get >= 0; --get) {
                    int slotID = slots[get];
                    ItemStack invStack = sidedInventory.func_70301_a(slotID);
                    if (invStack == null || invStack.field_77994_a <= 0) continue;
                    ItemStack toSend = invStack.func_77946_l();
                    toSend.field_77994_a = Math.min(amount, toSend.field_77994_a);
                    if (ret.hasType(toSend) || !sidedInventory.func_180461_b(slotID, toSend, side.func_176734_d()) || !finder.modifies(toSend)) continue;
                    ret.setItem(toSend, slotID);
                }
                break block7;
            }
            if (tile instanceof IInventory) {
                IInventory inventory = InventoryUtils.checkChestInv((IInventory)tile);
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    toSend.field_77994_a = Math.min(amount, toSend.field_77994_a);
                    if (ret.hasType(toSend) || !finder.modifies(toSend)) continue;
                    ret.setItem(toSend, i);
                }
            } else if (InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
                IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
                for (int i = inventory.getSlots() - 1; i >= 0; --i) {
                    ItemStack stack = inventory.extractItem(i, amount, true);
                    if (stack == null || ret.hasType(stack) || !finder.modifies(stack)) continue;
                    ret.setItem(stack, i);
                }
            }
        }
        return ret;
    }

    public static class TransitResponse {
        public static final TransitResponse EMPTY = new TransitResponse(-1, null);
        public int slotID;
        public ItemStack stack = null;

        public TransitResponse(int s, ItemStack i) {
            this.slotID = s;
            this.stack = i;
        }

        public boolean isEmpty() {
            return this.stack == null;
        }

        public ItemStack getRejected(ItemStack orig) {
            return StackUtils.size(orig, orig.field_77994_a - (this.stack != null ? this.stack.field_77994_a : 0));
        }

        public InvStack getInvStack(TileEntity tile, EnumFacing side) {
            return new InvStack(tile, this.slotID, this.stack, side);
        }
    }
}

