/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.frequency;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.UsernameCache;

public class Frequency {
    public static final String TELEPORTER = "Teleporter";
    public String name;
    public UUID ownerUUID;
    public String clientOwner;
    public boolean valid = true;
    public boolean publicFreq;
    public Set<Coord4D> activeCoords = new HashSet<Coord4D>();

    public Frequency(String n, UUID uuid) {
        this.name = n;
        this.ownerUUID = uuid;
    }

    public Frequency(NBTTagCompound nbtTags) {
        this.read(nbtTags);
    }

    public Frequency(ByteBuf dataStream) {
        this.read(dataStream);
    }

    public Frequency setPublic(boolean isPublic) {
        this.publicFreq = isPublic;
        return this;
    }

    public boolean isPublic() {
        return this.publicFreq;
    }

    public boolean isPrivate() {
        return !this.publicFreq;
    }

    public Coord4D getClosestCoords(Coord4D coord) {
        Coord4D closest = null;
        for (Coord4D iterCoord : this.activeCoords) {
            if (iterCoord.equals(coord)) continue;
            if (closest == null) {
                closest = iterCoord;
                continue;
            }
            if (coord.dimensionId != closest.dimensionId && coord.dimensionId == iterCoord.dimensionId) {
                closest = iterCoord;
                continue;
            }
            if (coord.dimensionId == closest.dimensionId && coord.dimensionId != iterCoord.dimensionId || coord.distanceTo(closest) <= coord.distanceTo(iterCoord)) continue;
            closest = iterCoord;
        }
        return closest;
    }

    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74778_a("name", this.name);
        nbtTags.func_74778_a("ownerUUID", this.ownerUUID.toString());
        nbtTags.func_74757_a("publicFreq", this.publicFreq);
    }

    protected void read(NBTTagCompound nbtTags) {
        this.name = nbtTags.func_74779_i("name");
        if (nbtTags.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbtTags.func_74779_i("ownerUUID"));
        } else if (nbtTags.func_74764_b("owner")) {
            String oldOwner = nbtTags.func_74779_i("owner");
            for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
                if (!((String)entry.getValue()).equals(oldOwner)) continue;
                this.ownerUUID = (UUID)entry.getKey();
                break;
            }
        }
        this.publicFreq = nbtTags.func_74767_n("publicFreq");
    }

    public void write(ArrayList<Object> data) {
        data.add(this.name);
        data.add(this.ownerUUID.toString());
        data.add(MekanismUtils.getLastKnownUsername(this.ownerUUID));
        data.add(this.publicFreq);
    }

    protected void read(ByteBuf dataStream) {
        this.name = PacketHandler.readString(dataStream);
        this.ownerUUID = UUID.fromString(PacketHandler.readString(dataStream));
        this.clientOwner = PacketHandler.readString(dataStream);
        this.publicFreq = dataStream.readBoolean();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.name.hashCode();
        code = 31 * code + this.ownerUUID.hashCode();
        code = 31 * code + (this.publicFreq ? 1 : 0);
        return code;
    }

    public boolean equals(Object obj) {
        return obj instanceof Frequency && ((Frequency)obj).name.equals(this.name) && ((Frequency)obj).ownerUUID.equals(this.ownerUUID) && ((Frequency)obj).publicFreq == this.publicFreq;
    }
}

