/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.recipe.ShapelessMekanismRecipe;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.util.RecipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class IMCHandler {
    @Mod.EventHandler
    public void onIMCEvent(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage msg : messages) {
            if (!msg.isNBTMessage()) continue;
            try {
                Object recipe;
                boolean found = false;
                boolean delete = false;
                String message = msg.key;
                if (message.equals("ShapedMekanismRecipe")) {
                    recipe = ShapedMekanismRecipe.create(msg.getNBTValue());
                    if (recipe != null) {
                        GameRegistry.addRecipe((IRecipe)recipe);
                        Mekanism.logger.info("[Mekanism] " + msg.getSender() + " added a shaped recipe to the recipe list.");
                    } else {
                        Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to add an invalid shaped recipe.");
                    }
                    found = true;
                } else if (message.equals("ShapelessMekanismRecipe")) {
                    recipe = ShapelessMekanismRecipe.create(msg.getNBTValue());
                    if (recipe != null) {
                        GameRegistry.addRecipe((IRecipe)recipe);
                        Mekanism.logger.info("[Mekanism] " + msg.getSender() + " added a shapeless recipe to the recipe list.");
                    } else {
                        Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to add an invalid shapeless recipe.");
                    }
                    found = true;
                } else if (message.equals("DeleteMekanismRecipes") || message.equals("RemoveMekanismRecipes")) {
                    ItemStack stack = RecipeUtils.loadRecipeItemStack(msg.getNBTValue());
                    if (stack != null) {
                        RecipeUtils.removeRecipes(stack);
                        Mekanism.logger.info("[Mekanism] " + msg.getSender() + " removed a Mekanism recipe from the recipe list.");
                    } else {
                        Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to remove a Mekanism recipe with an invalid output.");
                    }
                    found = true;
                }
                if (message.startsWith("Delete") || message.startsWith("Remove")) {
                    message = message.replace("Delete", "").replace("Remove", "");
                    delete = true;
                }
                for (RecipeHandler.Recipe type : RecipeHandler.Recipe.values()) {
                    if (!message.equalsIgnoreCase(type.getRecipeName() + "Recipe")) continue;
                    MachineInput input = (MachineInput)type.createInput(msg.getNBTValue());
                    if (input != null && input.isValid()) {
                        MachineRecipe recipe2 = (MachineRecipe)type.createRecipe(input, msg.getNBTValue());
                        if (recipe2 != null && recipe2.recipeOutput != null) {
                            if (delete) {
                                RecipeHandler.removeRecipe(type, recipe2);
                                Mekanism.logger.info("[Mekanism] " + msg.getSender() + " removed recipe of type " + type.getRecipeName() + " from the recipe list.");
                            } else {
                                RecipeHandler.addRecipe(type, recipe2);
                                Mekanism.logger.info("[Mekanism] " + msg.getSender() + " added recipe of type " + type.getRecipeName() + " to the recipe list.");
                            }
                        } else {
                            Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to " + (delete ? "remove" : "add") + " recipe of type " + type.getRecipeName() + " with an invalid output.");
                        }
                    } else {
                        Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to " + (delete ? "remove" : "add") + " recipe of type " + type.getRecipeName() + " with an invalid input.");
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                Mekanism.logger.error("[Mekanism] " + msg.getSender() + " sent unknown IMC message with key '" + msg.key + ".'");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

