/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.Collections;
import java.util.List;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.MekanismItems;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.multipart.ColorProperty;
import mekanism.common.multipart.GlowPanelBlockState;
import mekanism.common.multipart.MultipartMekanism;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class PartGlowPanel
extends Multipart
implements INormallyOccludingPart {
    public EnumColor colour = EnumColor.WHITE;
    public EnumFacing side = EnumFacing.DOWN;
    public static AxisAlignedBB[] bounds = new AxisAlignedBB[6];

    public PartGlowPanel() {
    }

    public PartGlowPanel(EnumColor colour, EnumFacing side) {
        this.setColour(colour);
        this.setOrientation(side);
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(bounds[this.side.ordinal()]);
    }

    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:glow_panel");
    }

    public void setColour(EnumColor newColour) {
        this.colour = newColour;
    }

    public void setOrientation(EnumFacing newSide) {
        this.side = newSide;
    }

    public void onNeighborTileChange(EnumFacing side) {
        if (!this.getWorld().field_72995_K && !this.canStay()) {
            MultipartMekanism.dropItem(new ItemStack(MekanismItems.GlowPanel, 1, this.colour.getMetaValue()), this);
            this.getContainer().removePart((IMultipart)this);
        }
    }

    public void onPartChanged(IMultipart other) {
        if (!this.getWorld().field_72995_K && !this.canStay()) {
            MultipartMekanism.dropItem(new ItemStack(MekanismItems.GlowPanel, 1, this.colour.getMetaValue()), this);
            this.getContainer().removePart((IMultipart)this);
        }
    }

    public void writeUpdatePacket(PacketBuffer data) {
        data.writeInt(this.side.ordinal());
        data.writeInt(this.colour.getMetaValue());
    }

    public void readUpdatePacket(PacketBuffer data) {
        this.side = EnumFacing.func_82600_a((int)data.readInt());
        this.colour = EnumColor.DYES[data.readInt()];
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("side", this.side.ordinal());
        nbt.func_74768_a("colour", this.colour.getMetaValue());
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.side = EnumFacing.func_82600_a((int)nbt.func_74762_e("side"));
        this.colour = EnumColor.DYES[nbt.func_74762_e("colour")];
    }

    public int getLightValue() {
        return 15;
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        this.addSelectionBoxes(list);
    }

    public float getHardness(PartMOP partHit) {
        return 3.5f;
    }

    public List<ItemStack> getDrops() {
        return Collections.singletonList(this.getPickBlock(null, null));
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return new ItemStack(MekanismItems.GlowPanel, 1, this.colour.getMetaValue());
    }

    public boolean canStay() {
        Coord4D adj = new Coord4D(this.getPos().func_177972_a(this.side), this.getWorld());
        return this.getWorld().isSideSolid(adj.getPos(), this.side.func_176734_d()) || this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)this.side)) instanceof IMicroblock.IFaceMicroblock && ((IMicroblock.IFaceMicroblock)this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)this.side))).isFaceHollow();
    }

    public ResourceLocation getModelPath() {
        return this.getType();
    }

    public BlockStateContainer createBlockState() {
        return new GlowPanelBlockState();
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)this.side);
    }

    public IBlockState getExtendedState(IBlockState state) {
        if ((state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)this.side)) instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)ColorProperty.INSTANCE, (Object)new ColorProperty(this.colour));
        }
        return state;
    }

    public static int hash(IExtendedBlockState state) {
        int hash = 1;
        hash = 31 * hash + ((ColorProperty)state.getValue((IUnlistedProperty)ColorProperty.INSTANCE)).color.ordinal();
        hash = 31 * hash + ((EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty)).ordinal();
        return hash;
    }

    public boolean shouldBreakingUseExtendedState() {
        return true;
    }

    static {
        AxisAlignedBB cuboid = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
        Vec3d fromOrigin = new Vec3d(-0.5, -0.5, -0.5);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            PartGlowPanel.bounds[side.ordinal()] = MultipartMekanism.rotate(cuboid.func_72317_d(fromOrigin.field_72450_a, fromOrigin.field_72448_b, fromOrigin.field_72449_c), side).func_72317_d(-fromOrigin.field_72450_a, -fromOrigin.field_72449_c, -fromOrigin.field_72449_c);
        }
    }
}

