/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class PressurizedInput
extends MachineInput<PressurizedInput> {
    private ItemStack theSolid;
    private FluidStack theFluid;
    private GasStack theGas;

    public PressurizedInput(ItemStack solid, FluidStack fluid, GasStack gas) {
        this.theSolid = solid;
        this.theFluid = fluid;
        this.theGas = gas;
    }

    public PressurizedInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.theSolid = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("itemInput"));
        this.theFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("fluidInput"));
        this.theGas = GasStack.readFromNBT(nbtTags.func_74775_l("gasInput"));
    }

    @Override
    public boolean isValid() {
        return this.theSolid != null && this.theFluid != null && this.theGas != null;
    }

    public boolean use(ItemStack[] inventory, int index, FluidTank fluidTank, GasTank gasTank, boolean deplete) {
        if (this.meets(new PressurizedInput(inventory[index], fluidTank.getFluid(), gasTank.getGas()))) {
            if (deplete) {
                inventory[index] = StackUtils.subtract(inventory[index], this.theSolid);
                fluidTank.drain(this.theFluid.amount, true);
                gasTank.draw(this.theGas.amount, true);
            }
            return true;
        }
        return false;
    }

    public boolean containsType(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return false;
        }
        return StackUtils.equalsWildcard(stack, this.theSolid);
    }

    public boolean containsType(FluidStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isFluidEqual(this.theFluid);
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.theGas);
    }

    public boolean meets(PressurizedInput input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (!(StackUtils.equalsWildcard(input.theSolid, this.theSolid) && input.theFluid.isFluidEqual(this.theFluid) && input.theGas.isGasEqual(this.theGas))) {
            return false;
        }
        return input.theSolid.field_77994_a >= this.theSolid.field_77994_a && input.theFluid.amount >= this.theFluid.amount && input.theGas.amount >= this.theGas.amount;
    }

    @Override
    public PressurizedInput copy() {
        return new PressurizedInput(this.theSolid.func_77946_l(), this.theFluid.copy(), this.theGas.copy());
    }

    public ItemStack getSolid() {
        return this.theSolid;
    }

    public FluidStack getFluid() {
        return this.theFluid;
    }

    public GasStack getGas() {
        return this.theGas;
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.theSolid) << 16 | (this.theFluid.getFluid() != null ? this.theFluid.getFluid().hashCode() : 0) << 8 | this.theGas.hashCode();
    }

    @Override
    public boolean testEquality(PressurizedInput other) {
        return other.containsType(this.theSolid) && other.containsType(this.theFluid) && other.containsType(this.theGas);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof PressurizedInput;
    }
}

