/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import java.util.Random;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ChanceOutput
extends MachineOutput<ChanceOutput> {
    private static Random rand = new Random();
    public ItemStack primaryOutput;
    public ItemStack secondaryOutput;
    public double secondaryChance;

    public ChanceOutput(ItemStack primary, ItemStack secondary, double chance) {
        this.primaryOutput = primary;
        this.secondaryOutput = secondary;
        this.secondaryChance = chance;
    }

    public ChanceOutput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.primaryOutput = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("primaryOutput"));
        this.secondaryOutput = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("secondaryOutput"));
        this.secondaryChance = nbtTags.func_74769_h("secondaryChance");
    }

    public ChanceOutput(ItemStack primary) {
        this.primaryOutput = primary;
    }

    public boolean checkSecondary() {
        return rand.nextDouble() <= this.secondaryChance;
    }

    public boolean hasPrimary() {
        return this.primaryOutput != null;
    }

    public boolean hasSecondary() {
        return this.secondaryOutput != null;
    }

    public boolean applyOutputs(ItemStack[] inventory, int primaryIndex, int secondaryIndex, boolean doEmit) {
        if (this.hasPrimary()) {
            if (inventory[primaryIndex] == null) {
                if (doEmit) {
                    inventory[primaryIndex] = this.primaryOutput.func_77946_l();
                }
            } else if (inventory[primaryIndex].func_77969_a(this.primaryOutput) && inventory[primaryIndex].field_77994_a + this.primaryOutput.field_77994_a <= inventory[primaryIndex].func_77976_d()) {
                if (doEmit) {
                    inventory[primaryIndex].field_77994_a += this.primaryOutput.field_77994_a;
                }
            } else {
                return false;
            }
        }
        if (this.hasSecondary() && (!doEmit || this.checkSecondary())) {
            if (inventory[secondaryIndex] == null) {
                if (doEmit) {
                    inventory[secondaryIndex] = this.secondaryOutput.func_77946_l();
                }
                return true;
            }
            if (inventory[secondaryIndex].func_77969_a(this.secondaryOutput) && inventory[secondaryIndex].field_77994_a + this.primaryOutput.field_77994_a <= inventory[secondaryIndex].func_77976_d()) {
                if (doEmit) {
                    inventory[secondaryIndex].field_77994_a += this.secondaryOutput.field_77994_a;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public ChanceOutput copy() {
        return new ChanceOutput(StackUtils.copy(this.primaryOutput), StackUtils.copy(this.secondaryOutput), this.secondaryChance);
    }
}

