/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityOperationalMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalCrystallizer
extends TileEntityOperationalMachine
implements IGasHandler,
ITubeConnection,
ISideConfiguration,
ISustainedData,
ITankManager,
IConfigCardAccess {
    public static final int MAX_GAS = 10000;
    public GasTank inputTank = new GasTank(10000);
    public CrystallizerRecipe cachedRecipe;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);

    public TileEntityChemicalCrystallizer() {
        super("machine.crystallizer", "ChemicalCrystallizer", BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER.baseEnergy, MekanismConfig.usage.chemicalCrystallizerUsage, 3, 200);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Gas", EnumColor.PURPLE, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 3, 0, 0, 1, 2});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.YELLOW, new int[]{0}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{-1, -1, -1, -1, 1, -1});
        this.configComponent.setCanEject(TransmissionType.GAS, false);
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = new ItemStack[4];
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            CrystallizerRecipe recipe;
            ChargeUtils.discharge(2, this);
            if (this.inventory[0] != null && (this.inputTank.getGas() == null || this.inputTank.getStored() < this.inputTank.getMaxGas())) {
                this.inputTank.receive(GasUtils.removeGas(this.inventory[0], this.inputTank.getGasType(), this.inputTank.getNeeded()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    public CrystallizerRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalCrystallizerRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public boolean canOperate(CrystallizerRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.inventory);
    }

    public void operate(CrystallizerRecipe recipe) {
        recipe.operate(this.inputTank, this.inventory);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (dataStream.readBoolean()) {
                this.inputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.inputTank.setGas(null);
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        if (this.inputTank.getGas() != null) {
            data.add(true);
            data.add(this.inputTank.getGas().getGas().getID());
            data.add(this.inputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.inputTank.read(nbtTags.func_74775_l("rightTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("rightTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("sideDataStored", true);
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0) && this.inputTank.canReceive(type) && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(type);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.inputTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas());
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 1) {
            return true;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank};
    }
}

