/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class FluidContainerUtils {
    public static boolean isFluidContainer(ItemStack stack) {
        return stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public static FluidStack extractFluid(FluidTank tileTank, TileEntityContainerBlock tile, int slotID) {
        return FluidContainerUtils.extractFluid(tileTank, tile, slotID, FluidChecker.check(tileTank.getFluid()));
    }

    public static FluidStack extractFluid(FluidTank tileTank, TileEntityContainerBlock tile, int slotID, FluidChecker checker) {
        return FluidContainerUtils.extractFluid(tileTank.getCapacity() - tileTank.getFluidAmount(), tile.inventory, slotID, checker);
    }

    public static FluidStack extractFluid(int needed, ItemStack[] inv, int slotID, FluidChecker checker) {
        IFluidHandler handler = FluidUtil.getFluidHandler((ItemStack)inv[slotID]);
        if (handler == null || FluidUtil.getFluidContained((ItemStack)inv[slotID]) == null) {
            return null;
        }
        if (checker != null && !checker.isValid(FluidUtil.getFluidContained((ItemStack)inv[slotID]).getFluid())) {
            return null;
        }
        return handler.drain(needed, true);
    }

    public static int insertFluid(FluidTank tileTank, ItemStack container) {
        return FluidContainerUtils.insertFluid(tileTank.getFluid(), container);
    }

    public static int insertFluid(FluidStack fluid, ItemStack container) {
        IFluidHandler handler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluid == null) {
            return 0;
        }
        return handler.fill(fluid, true);
    }

    public static void handleContainerItemFill(TileEntityContainerBlock tileEntity, FluidTank tank, int inSlot, int outSlot) {
        tank.setFluid(FluidContainerUtils.handleContainerItemFill(tileEntity, tileEntity.inventory, tank.getFluid(), inSlot, outSlot));
    }

    public static FluidStack handleContainerItemFill(TileEntity tileEntity, ItemStack[] inventory, FluidStack stack, int inSlot, int outSlot) {
        if (stack != null) {
            ItemStack inputCopy = StackUtils.size(inventory[inSlot].func_77946_l(), 1);
            int drained = FluidContainerUtils.insertFluid(stack, inputCopy);
            if (!(inventory[outSlot] == null || ItemHandlerHelper.canItemStacksStack((ItemStack)inventory[outSlot], (ItemStack)inputCopy) && inventory[outSlot].field_77994_a != inventory[outSlot].func_77976_d())) {
                return stack;
            }
            stack.amount -= drained;
            if (inventory[outSlot] == null) {
                inventory[outSlot] = inputCopy;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)inventory[outSlot], (ItemStack)inputCopy)) {
                ++inventory[outSlot].field_77994_a;
            }
            --inventory[inSlot].field_77994_a;
            if (inventory[inSlot].field_77994_a == 0) {
                inventory[inSlot] = null;
            }
            if (stack.amount == 0) {
                stack = null;
            }
            tileEntity.func_70296_d();
        }
        return stack;
    }

    public static void handleContainerItemEmpty(TileEntityContainerBlock tileEntity, FluidTank tank, int inSlot, int outSlot) {
        FluidContainerUtils.handleContainerItemEmpty(tileEntity, tank, inSlot, outSlot, null);
    }

    public static void handleContainerItemEmpty(TileEntityContainerBlock tileEntity, FluidTank tank, int inSlot, int outSlot, FluidChecker checker) {
        tank.setFluid(FluidContainerUtils.handleContainerItemEmpty(tileEntity, tileEntity.inventory, tank.getFluid(), tank.getCapacity() - tank.getFluidAmount(), inSlot, outSlot, checker));
    }

    public static FluidStack handleContainerItemEmpty(TileEntity tileEntity, ItemStack[] inventory, FluidStack stored, int needed, int inSlot, int outSlot, final FluidChecker checker) {
        final Fluid storedFinal = stored != null ? stored.getFluid() : null;
        FluidStack ret = FluidContainerUtils.extractFluid(needed, inventory, inSlot, new FluidChecker(){

            @Override
            public boolean isValid(Fluid f) {
                return !(checker != null && !checker.isValid(f) || storedFinal != null && storedFinal != f);
            }
        });
        if (ret != null) {
            if (stored == null) {
                stored = ret;
            } else {
                stored.amount += ret.amount;
            }
            needed -= ret.amount;
            tileEntity.func_70296_d();
        }
        if (FluidUtil.getFluidContained((ItemStack)inventory[inSlot]) == null || needed == 0) {
            if (inventory[inSlot].field_77994_a > 0) {
                if (inventory[outSlot] == null) {
                    inventory[outSlot] = inventory[inSlot].func_77946_l();
                    inventory[inSlot] = null;
                } else if (inventory[outSlot].func_77969_a(inventory[inSlot]) && ItemStack.func_77970_a((ItemStack)inventory[inSlot], (ItemStack)inventory[outSlot])) {
                    ++inventory[outSlot].field_77994_a;
                    inventory[inSlot] = null;
                }
                tileEntity.func_70296_d();
            } else {
                inventory[inSlot] = null;
                tileEntity.func_70296_d();
            }
        }
        return stored;
    }

    public static void handleContainerItem(TileEntityContainerBlock tileEntity, ContainerEditMode editMode, FluidTank tank, int inSlot, int outSlot) {
        FluidContainerUtils.handleContainerItem(tileEntity, editMode, tank, inSlot, outSlot, null);
    }

    public static void handleContainerItem(TileEntityContainerBlock tileEntity, ContainerEditMode editMode, FluidTank tank, int inSlot, int outSlot, FluidChecker checker) {
        tank.setFluid(FluidContainerUtils.handleContainerItem(tileEntity, tileEntity.inventory, editMode, tank.getFluid(), tank.getCapacity() - tank.getFluidAmount(), inSlot, outSlot, checker));
    }

    public static FluidStack handleContainerItem(TileEntity tileEntity, ItemStack[] inventory, ContainerEditMode editMode, FluidStack stack, int needed, int inSlot, int outSlot, FluidChecker checker) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)inventory[inSlot]);
        if (editMode == ContainerEditMode.FILL || editMode == ContainerEditMode.BOTH && fluidStack == null) {
            return FluidContainerUtils.handleContainerItemFill(tileEntity, inventory, stack, inSlot, outSlot);
        }
        if (editMode == ContainerEditMode.EMPTY || editMode == ContainerEditMode.BOTH && fluidStack != null) {
            return FluidContainerUtils.handleContainerItemEmpty(tileEntity, inventory, stack, needed, inSlot, outSlot, checker);
        }
        return stack;
    }

    public static class FluidChecker {
        public boolean isValid(Fluid f) {
            return true;
        }

        public static FluidChecker check(FluidStack fluid) {
            final Fluid type = fluid != null ? fluid.getFluid() : null;
            return new FluidChecker(){

                @Override
                public boolean isValid(Fluid f) {
                    return type == null || type == f;
                }
            };
        }

        public static FluidChecker check(final Fluid type) {
            return new FluidChecker(){

                @Override
                public boolean isValid(Fluid f) {
                    return type == null || type == f;
                }
            };
        }
    }

    public static enum ContainerEditMode {
        BOTH("fluidedit.both"),
        FILL("fluidedit.fill"),
        EMPTY("fluidedit.empty");

        private String display;

        public String getDisplay() {
            return LangUtils.localize(this.display);
        }

        private ContainerEditMode(String s) {
            this.display = s;
        }
    }
}

