/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import com.mojang.authlib.GameProfile;
import ic2.api.energy.EnergyNet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcmultipart.multipart.Multipart;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IMekWrench;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.OreDictCache;
import mekanism.common.Tier;
import mekanism.common.Upgrade;
import mekanism.common.Version;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IFactory;
import mekanism.common.base.IModule;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.InventoryPersonalChest;
import mekanism.common.inventory.container.ContainerPersonalChest;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.network.PacketPersonalChest;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class MekanismUtils {
    public static final EnumFacing[] SIDE_DIRS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    public static final Map<String, Class<?>> classesFound = new HashMap();
    private static final List<UUID> warnedFails = new ArrayList<UUID>();

    public static boolean checkForUpdates(EntityPlayer entityplayer) {
        try {
            if (MekanismConfig.general.updateNotifications && Mekanism.latestVersionNumber != null && Mekanism.recentNews != null) {
                if (!Mekanism.latestVersionNumber.equals("null")) {
                    ArrayList<IModule> list = new ArrayList<IModule>();
                    for (IModule module : Mekanism.modulesLoaded) {
                        if (Version.get(Mekanism.latestVersionNumber).comparedState(module.getVersion()) != 1) continue;
                        list.add(module);
                    }
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1 || !list.isEmpty()) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("update.outdated") + "."));
                        if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1) {
                            entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.INDIGO) + " Mekanism: " + (Object)((Object)EnumColor.DARK_RED) + Mekanism.versionNumber));
                        }
                        for (IModule module : list) {
                            entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.INDIGO) + " Mekanism" + module.getName() + ": " + (Object)((Object)EnumColor.DARK_RED) + module.getVersion()));
                        }
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("update.consider") + " " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.latestVersionNumber));
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("update.newFeatures") + ": " + (Object)((Object)EnumColor.INDIGO) + Mekanism.recentNews));
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("update.visit") + " " + (Object)((Object)EnumColor.DARK_GREY) + "aidancbrady.com/mekanism" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("update.toDownload") + "."));
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                        return true;
                    }
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == -1) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("update.devBuild") + " " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.versionNumber));
                        return true;
                    }
                } else {
                    Mekanism.logger.info("Minecraft is in offline mode, could not check for updates.");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void updateDonators() {
        Mekanism.donators.clear();
        for (String s : MekanismUtils.getHTML("https://dl.dropbox.com/u/90411166/Donators/Mekanism.txt")) {
            Mekanism.donators.add(s);
        }
    }

    public static List<String> getHTML(String urlToRead) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.add(line.trim());
            }
            rd.close();
        }
        catch (Exception e) {
            result.clear();
            result.add("null");
            Mekanism.logger.error("An error occured while connecting to URL '" + urlToRead + ".'");
        }
        return result;
    }

    public static String merge(List<String> text) {
        StringBuilder builder = new StringBuilder();
        for (String s : text) {
            builder.append(s);
        }
        return builder.toString();
    }

    public static boolean noUpdates() {
        if (Mekanism.latestVersionNumber.contains("null")) {
            return true;
        }
        if (Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1) {
            return false;
        }
        for (IModule module : Mekanism.modulesLoaded) {
            if (module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isOffline() {
        try {
            new URL("http://www.apple.com").openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ItemStack size(ItemStack itemstack, int size) {
        ItemStack newStack = itemstack.func_77946_l();
        newStack.field_77994_a = size;
        return newStack;
    }

    public static void addRecipe(ItemStack output, Object[] params) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(output, params));
    }

    public static ItemStack getEnergyCube(Tier.EnergyCubeTier tier) {
        return ((ItemBlockEnergyCube)new ItemStack(MekanismBlocks.EnergyCube).func_77973_b()).getUnchargedItem(tier);
    }

    public static Object getControlCircuit(Tier.BaseTier tier) {
        return MekanismConfig.general.controlCircuitOreDict ? "circuit" + tier.getSimpleName() : new ItemStack(MekanismItems.ControlCircuit, 1, tier.ordinal());
    }

    public static ItemStack getInductionCell(Tier.InductionCellTier tier) {
        return ((ItemBlockBasic)new ItemStack(MekanismBlocks.BasicBlock2, 1, 3).func_77973_b()).getUnchargedCell(tier);
    }

    public static ItemStack getInductionProvider(Tier.InductionProviderTier tier) {
        return ((ItemBlockBasic)new ItemStack(MekanismBlocks.BasicBlock2, 1, 4).func_77973_b()).getUnchargedProvider(tier);
    }

    public static ItemStack getBin(Tier.BinTier tier) {
        ItemStack ret = new ItemStack(MekanismBlocks.BasicBlock, 1, 6);
        ((ItemBlockBasic)ret.func_77973_b()).setBaseTier(ret, tier.getBaseTier());
        return ret;
    }

    public static ItemStack getEmptyGasTank(Tier.GasTankTier tier) {
        return ((ItemBlockGasTank)new ItemStack(MekanismBlocks.GasTank).func_77973_b()).getEmptyItem(tier);
    }

    public static ItemStack getEmptyFluidTank(Tier.FluidTankTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.MachineBlock2, 1, 11);
        ItemBlockMachine itemMachine = (ItemBlockMachine)stack.func_77973_b();
        itemMachine.setBaseTier(stack, tier.getBaseTier());
        return stack;
    }

    public static ItemStack getFactory(Tier.FactoryTier tier, IFactory.RecipeType type) {
        ItemStack itemstack = new ItemStack(MekanismBlocks.MachineBlock, 1, BlockStateMachine.MachineType.BASIC_FACTORY.ordinal() + tier.ordinal());
        ((IFactory)itemstack.func_77973_b()).setRecipeType(type.ordinal(), itemstack);
        return itemstack;
    }

    public static boolean isActive(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof IActiveState) {
            return ((IActiveState)tileEntity).getActive();
        }
        return false;
    }

    public static EnumFacing getLeft(EnumFacing orientation) {
        return orientation.func_176746_e();
    }

    public static EnumFacing getRight(EnumFacing orientation) {
        return orientation.func_176735_f();
    }

    public static EnumFacing getBack(EnumFacing orientation) {
        return orientation.func_176734_d();
    }

    public static boolean oreDictCheck(ItemStack check, String oreDict) {
        boolean hasResource = false;
        for (ItemStack ore : OreDictionary.getOres((String)oreDict)) {
            if (!ore.func_77969_a(check)) continue;
            hasResource = true;
        }
        return hasResource;
    }

    public static List<String> getOreDictName(ItemStack check) {
        return OreDictCache.getOreDictName(check);
    }

    public static EnumFacing getBaseOrientation(EnumFacing side, EnumFacing blockFacing) {
        if (blockFacing == EnumFacing.DOWN) {
            switch (side) {
                case DOWN: {
                    return EnumFacing.NORTH;
                }
                case UP: {
                    return EnumFacing.SOUTH;
                }
                case NORTH: {
                    return EnumFacing.UP;
                }
                case SOUTH: {
                    return EnumFacing.DOWN;
                }
            }
            return side;
        }
        if (blockFacing == EnumFacing.UP) {
            switch (side) {
                case DOWN: {
                    return EnumFacing.SOUTH;
                }
                case UP: {
                    return EnumFacing.NORTH;
                }
                case NORTH: {
                    return EnumFacing.DOWN;
                }
                case SOUTH: {
                    return EnumFacing.UP;
                }
            }
            return side;
        }
        if (blockFacing == EnumFacing.SOUTH || side.func_176740_k() == EnumFacing.Axis.Y) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return side.func_176734_d();
            }
            return side;
        }
        if (blockFacing == EnumFacing.NORTH) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return side;
            }
            return side.func_176734_d();
        }
        if (blockFacing == EnumFacing.WEST) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return MekanismUtils.getRight(side);
            }
            return MekanismUtils.getLeft(side);
        }
        if (blockFacing == EnumFacing.EAST) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return MekanismUtils.getLeft(side);
            }
            return MekanismUtils.getRight(side);
        }
        return side;
    }

    public static void incrementOutput(ISideConfiguration config, TransmissionType type, EnumFacing direction) {
        int side = direction.ordinal();
        int max = config.getConfig().getOutputs(type).size() - 1;
        int current = config.getConfig().getOutputs(type).indexOf(config.getConfig().getOutputs(type).get(config.getConfig().getConfig(type)[side]));
        if (current < max) {
            config.getConfig().getConfig((TransmissionType)type)[side] = (byte)(current + 1);
        } else if (current == max) {
            config.getConfig().getConfig((TransmissionType)type)[side] = 0;
        }
        TileEntity tile = (TileEntity)config;
        tile.func_70296_d();
    }

    public static void decrementOutput(ISideConfiguration config, TransmissionType type, EnumFacing direction) {
        int side = direction.ordinal();
        int max = config.getConfig().getOutputs(type).size() - 1;
        int current = config.getConfig().getOutputs(type).indexOf(config.getConfig().getOutputs(type).get(config.getConfig().getConfig(type)[side]));
        if (current > 0) {
            config.getConfig().getConfig((TransmissionType)type)[side] = (byte)(current - 1);
        } else if (current == 0) {
            config.getConfig().getConfig((TransmissionType)type)[side] = (byte)max;
        }
        TileEntity tile = (TileEntity)config;
        tile.func_70296_d();
    }

    public static float fractionUpgrades(IUpgradeTile mgmt, Upgrade type) {
        return (float)mgmt.getComponent().getUpgrades(type) / (float)type.getMax();
    }

    public static int getTicks(IUpgradeTile mgmt, int def) {
        return (int)((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, -MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED)));
    }

    public static double getEnergyPerTick(IUpgradeTile mgmt, double def) {
        return def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, 2.0f * MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY));
    }

    public static double getBaseEnergyPerTick(IUpgradeTile mgmt, double def) {
        return def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, -MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY));
    }

    public static double getSecondaryEnergyPerTickMean(IUpgradeTile mgmt, int def) {
        if (mgmt.getComponent().supports(Upgrade.GAS)) {
            return (double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, 2.0f * MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(mgmt, Upgrade.GAS));
        }
        return (double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED));
    }

    public static double getMaxEnergy(IUpgradeTile mgmt, double def) {
        return def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY));
    }

    public static double getMaxEnergy(ItemStack itemStack, double def) {
        Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getDataMap(itemStack));
        float numUpgrades = upgrades.get((Object)Upgrade.ENERGY) == null ? 0.0f : (float)upgrades.get((Object)Upgrade.ENERGY).intValue();
        return def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier, numUpgrades / (float)Upgrade.ENERGY.getMax());
    }

    public static boolean isGettingPowered(World world, Coord4D coord) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D sideCoord = coord.offset(side);
            if (!sideCoord.exists(world) || !sideCoord.offset(side).exists(world)) continue;
            IBlockState blockState = sideCoord.getBlockState((IBlockAccess)world);
            boolean weakPower = blockState.func_177230_c().shouldCheckWeakPower(blockState, (IBlockAccess)world, coord.getPos(), side);
            if (weakPower && MekanismUtils.isDirectlyGettingPowered(world, sideCoord)) {
                return true;
            }
            if (weakPower || blockState.func_185911_a((IBlockAccess)world, sideCoord.getPos(), side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectlyGettingPowered(World world, Coord4D coord) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D sideCoord = coord.offset(side);
            if (!sideCoord.exists(world) || world.func_175651_c(coord.getPos(), side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void notifyLoadedNeighborsOfTileChange(World world, Coord4D coord) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Coord4D offset = coord.offset(dir);
            if (!offset.exists(world)) continue;
            Block block1 = offset.getBlock((IBlockAccess)world);
            block1.onNeighborChange((IBlockAccess)world, offset.getPos(), coord.getPos());
            if (!offset.getBlockState((IBlockAccess)world).func_185915_l() || !(offset = offset.offset(dir)).exists(world) || !(block1 = offset.getBlock((IBlockAccess)world)).getWeakChanges((IBlockAccess)world, offset.getPos())) continue;
            block1.onNeighborChange((IBlockAccess)world, offset.getPos(), coord.getPos());
        }
    }

    public static void makeBoundingBlock(World world, BlockPos boundingLocation, Coord4D orig) {
        world.func_175656_a(boundingLocation, MekanismBlocks.BoundingBlock.func_176203_a(0));
        if (!world.field_72995_K) {
            ((TileEntityBoundingBlock)world.func_175625_s(boundingLocation)).setMainLocation(orig.getPos());
        }
    }

    public static void makeAdvancedBoundingBlock(World world, BlockPos boundingLocation, Coord4D orig) {
        world.func_175656_a(boundingLocation, MekanismBlocks.BoundingBlock.func_176203_a(1));
        if (!world.field_72995_K) {
            ((TileEntityAdvancedBoundingBlock)world.func_175625_s(boundingLocation)).setMainLocation(orig.getPos());
        }
    }

    public static void updateBlock(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos) instanceof IActiveState) || ((IActiveState)world.func_175625_s(pos)).renderUpdate()) {
            world.func_175704_b(pos, pos.func_177982_a(1, 1, 1));
        }
        if (!(world.func_175625_s(pos) instanceof IActiveState) || ((IActiveState)world.func_175625_s(pos)).lightUpdate() && MekanismConfig.client.machineEffects) {
            MekanismUtils.updateAllLightTypes(world, pos);
        }
    }

    public static void updateAllLightTypes(World world, BlockPos pos) {
        world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        world.func_180500_c(EnumSkyBlock.SKY, pos);
    }

    public static boolean isFluid(World world, Coord4D pos) {
        return MekanismUtils.getFluid(world, pos, false) != null;
    }

    public static FluidStack getFluid(World world, Coord4D pos, boolean filter) {
        IBlockState state = pos.getBlockState((IBlockAccess)world);
        Block block = state.func_177230_c();
        if (block == null) {
            return null;
        }
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (!filter) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            return new FluidStack(MekanismFluids.HeavyWater, 10);
        }
        if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)block;
            if (state.func_177228_b().containsKey((Object)BlockFluidBase.LEVEL) && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0) {
                return fluid.drain(world, pos.getPos(), false);
            }
        }
        return null;
    }

    public static boolean isDeadFluid(World world, Coord4D pos) {
        IBlockState state = pos.getBlockState((IBlockAccess)world);
        Block block = state.func_177230_c();
        if (block == null || block.func_176201_c(state) == 0) {
            return false;
        }
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    public static Block getFlowingBlock(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid == FluidRegistry.WATER) {
            return Blocks.field_150358_i;
        }
        if (fluid == FluidRegistry.LAVA) {
            return Blocks.field_150356_k;
        }
        return fluid.getBlock();
    }

    public static void openPersonalChestGui(EntityPlayerMP player, TileEntityPersonalChest tileEntity, InventoryPersonalChest inventory, boolean isBlock) {
        player.func_71117_bO();
        player.func_71128_l();
        int id = player.field_71139_cq;
        if (isBlock) {
            Mekanism.packetHandler.sendTo(new PacketPersonalChest.PersonalChestMessage(PacketPersonalChest.PersonalChestPacketType.CLIENT_OPEN, true, 0, id, Coord4D.get(tileEntity), null), player);
        } else {
            Mekanism.packetHandler.sendTo(new PacketPersonalChest.PersonalChestMessage(PacketPersonalChest.PersonalChestPacketType.CLIENT_OPEN, false, 0, id, null, inventory.currentHand), player);
        }
        player.field_71070_bA = new ContainerPersonalChest(player.field_71071_by, tileEntity, (IInventory)inventory, isBlock);
        player.field_71070_bA.field_75152_c = id;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return new ResourceLocation("mekanism", type.getPrefix() + name);
    }

    public static boolean removeRecipes(ItemStack ... itemStacks) {
        boolean didRemove = false;
        Iterator itr = CraftingManager.func_77594_a().func_77592_b().iterator();
        block0: while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof IRecipe) || ((IRecipe)obj).func_77571_b() == null) continue;
            for (ItemStack itemStack : itemStacks) {
                if (!((IRecipe)obj).func_77571_b().func_77969_a(itemStack)) continue;
                itr.remove();
                didRemove = true;
                continue block0;
            }
        }
        return didRemove;
    }

    public static void saveChunk(TileEntity tileEntity) {
        if (tileEntity == null || tileEntity.func_145837_r() || tileEntity.func_145831_w() == null) {
            return;
        }
        tileEntity.func_145831_w().func_175646_b(tileEntity.func_174877_v(), tileEntity);
    }

    public static void saveChunk(Multipart multipart) {
        if (multipart == null || multipart.getWorld() == null) {
            return;
        }
        multipart.getWorld().func_175646_b(multipart.getPos(), null);
    }

    public static boolean canFunction(TileEntity tileEntity) {
        if (!(tileEntity instanceof IRedstoneControl)) {
            return true;
        }
        IRedstoneControl control = (IRedstoneControl)tileEntity;
        switch (control.getControlType()) {
            case DISABLED: {
                return true;
            }
            case HIGH: {
                return control.isPowered();
            }
            case LOW: {
                return !control.isPowered();
            }
            case PULSE: {
                return control.isPowered() && !control.wasPowered();
            }
        }
        return false;
    }

    public static RayTraceResult rayTrace(World world, EntityPlayer player) {
        double reach = Mekanism.proxy.getReach(player);
        Vec3d headVec = MekanismUtils.getHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_72901_a(headVec, endVec, true);
    }

    private static Vec3d getHeadVec(EntityPlayer player) {
        double posX = player.field_70165_t;
        double posY = player.field_70163_u;
        double posZ = player.field_70161_v;
        if (!player.field_70170_p.field_72995_K) {
            posY += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                posY -= 0.08;
            }
        }
        return new Vec3d(posX, posY, posZ);
    }

    public static String getEnergyDisplay(double energy) {
        if (energy == Double.MAX_VALUE) {
            return LangUtils.localize("gui.infinite");
        }
        switch (MekanismConfig.general.energyUnit) {
            case J: {
                return UnitDisplayUtils.getDisplayShort(energy, UnitDisplayUtils.ElectricUnit.JOULES);
            }
            case RF: {
                return UnitDisplayUtils.getDisplayShort(energy * MekanismConfig.general.TO_RF, UnitDisplayUtils.ElectricUnit.REDSTONE_FLUX);
            }
            case EU: {
                return UnitDisplayUtils.getDisplayShort(energy * MekanismConfig.general.TO_IC2, UnitDisplayUtils.ElectricUnit.ELECTRICAL_UNITS);
            }
            case T: {
                return UnitDisplayUtils.getDisplayShort(energy * MekanismConfig.general.TO_TESLA, UnitDisplayUtils.ElectricUnit.TESLA);
            }
        }
        return "error";
    }

    public static double convertToJoules(double energy) {
        switch (MekanismConfig.general.energyUnit) {
            case RF: {
                return energy * MekanismConfig.general.FROM_RF;
            }
            case EU: {
                return energy * MekanismConfig.general.FROM_IC2;
            }
            case T: {
                return energy * MekanismConfig.general.FROM_TESLA;
            }
        }
        return energy;
    }

    public static double convertToDisplay(double energy) {
        switch (MekanismConfig.general.energyUnit) {
            case RF: {
                return energy * MekanismConfig.general.TO_RF;
            }
            case EU: {
                return energy * MekanismConfig.general.TO_IC2;
            }
            case T: {
                return energy * MekanismConfig.general.TO_RF / 10.0;
            }
        }
        return energy;
    }

    public static String getTemperatureDisplay(double T, UnitDisplayUtils.TemperatureUnit unit) {
        double TK = unit.convertToK(T, true);
        switch (MekanismConfig.general.tempUnit) {
            case K: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.KELVIN);
            }
            case C: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.CELSIUS);
            }
            case R: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.RANKINE);
            }
            case F: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT);
            }
            case STP: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.AMBIENT);
            }
        }
        return "error";
    }

    public static boolean useIC2() {
        return Mekanism.hooks.IC2Loaded && EnergyNet.instance != null && !MekanismConfig.general.blacklistIC2;
    }

    public static boolean useRF() {
        return !MekanismConfig.general.blacklistRF;
    }

    public static boolean useTesla() {
        return Mekanism.hooks.TeslaLoaded && !MekanismConfig.general.blacklistTesla;
    }

    public static boolean useForge() {
        return !MekanismConfig.general.blacklistForge;
    }

    public static String getCoordDisplay(Coord4D obj) {
        return "[" + obj.xCoord + ", " + obj.yCoord + ", " + obj.zCoord + "]";
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> splitTooltip(String s, ItemStack stack) {
        s = s.trim();
        try {
            FontRenderer renderer = (FontRenderer)Mekanism.proxy.getFontRenderer();
            if (stack != null && stack.func_77973_b().getFontRenderer(stack) != null) {
                renderer = stack.func_77973_b().getFontRenderer(stack);
            }
            ArrayList<String> words = new ArrayList<String>();
            ArrayList<String> lines = new ArrayList<String>();
            String currentWord = "";
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (c.equals(Character.valueOf(' '))) {
                    words.add(currentWord);
                    currentWord = "";
                    continue;
                }
                currentWord = currentWord + c;
            }
            if (!currentWord.isEmpty()) {
                words.add(currentWord);
            }
            String currentLine = "";
            for (String word : words) {
                if (currentLine.isEmpty() || renderer.func_78256_a(currentLine + " " + word) <= 200) {
                    if (currentLine.length() > 0) {
                        currentLine = currentLine + " ";
                    }
                    currentLine = currentLine + word;
                    continue;
                }
                lines.add(currentLine);
                currentLine = word;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine);
            }
            return lines;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static ItemStack getFullGasTank(Tier.GasTankTier tier, Gas gas) {
        ItemStack tank = MekanismUtils.getEmptyGasTank(tier);
        ItemBlockGasTank item = (ItemBlockGasTank)tank.func_77973_b();
        item.setGas(tank, new GasStack(gas, item.MAX_GAS));
        return tank;
    }

    public static InventoryCrafting getDummyCraftingInv() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        return new InventoryCrafting(tempContainer, 3, 3);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[0] == null || dmgItems[0].func_77973_b() == null) {
            return null;
        }
        if (dmgItems[1] != null && dmgItems[0].func_77973_b() == dmgItems[1].func_77973_b() && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && dmgItems[0].func_77973_b().isRepairable()) {
            Item theItem = dmgItems[0].func_77973_b();
            int dmgDiff0 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int dmgDiff1 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int value = dmgDiff0 + dmgDiff1 + theItem.func_77612_l() * 5 / 100;
            int solve = Math.max(0, theItem.func_77612_l() - value);
            return new ItemStack(dmgItems[0].func_77973_b(), 1, solve);
        }
        ArrayList list = new ArrayList(CraftingManager.func_77594_a().func_77592_b());
        for (IRecipe recipe : list) {
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static boolean isChunkVibrated(Chunk3D chunk) {
        for (Coord4D coord : Mekanism.activeVibrators) {
            if (!coord.getChunk3D().equals(chunk)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOp(EntityPlayer p) {
        if (!(p instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)p;
        return MekanismConfig.general.opsBypassRestrictions && player.field_71133_b.func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static int getID(ItemStack itemStack) {
        if (itemStack == null) {
            return -1;
        }
        return Item.func_150891_b((Item)itemStack.func_77973_b());
    }

    public static boolean classExists(String className) {
        Class<?> found;
        if (classesFound.containsKey(className)) {
            return classesFound.get(className) != null;
        }
        try {
            found = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            found = null;
        }
        classesFound.put(className, found);
        return found != null;
    }

    public static boolean existsAndInstance(Object obj, String className) {
        Class<?> theClass;
        if (classesFound.containsKey(className)) {
            theClass = classesFound.get(className);
        } else {
            try {
                theClass = Class.forName(className);
                classesFound.put(className, theClass);
            }
            catch (ClassNotFoundException e) {
                classesFound.put(className, null);
                return false;
            }
        }
        return theClass != null && theClass.isInstance(obj);
    }

    public static boolean isBCWrench(Item tool) {
        return MekanismUtils.existsAndInstance(tool, "buildcraft.api.tools.IToolWrench");
    }

    public static boolean isCoFHHammer(Item tool) {
        return MekanismUtils.existsAndInstance(tool, "cofh.api.item.IToolHammer");
    }

    public static boolean hasUsableWrench(EntityPlayer player, BlockPos pos) {
        ItemStack tool = player.field_71071_by.func_70448_g();
        if (tool == null) {
            return false;
        }
        if (tool.func_77973_b() instanceof IMekWrench && ((IMekWrench)tool.func_77973_b()).canUseWrench(tool, player, pos)) {
            return true;
        }
        try {
            if (MekanismUtils.isBCWrench(tool.func_77973_b()) && ((IToolWrench)tool.func_77973_b()).canWrench(player, pos)) {
                return true;
            }
            if (MekanismUtils.isCoFHHammer(tool.func_77973_b()) && ((IToolHammer)tool.func_77973_b()).isUsable(tool, (EntityLivingBase)player, pos)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Nonnull
    public static String getLastKnownUsername(UUID uuid) {
        GameProfile gp;
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (gp = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(uuid)) != null) {
            ret = gp.getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", new Object[]{uuid});
            warnedFails.add(uuid);
        }
        return ret != null ? ret : "<???>";
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_ELEMENT("gui/elements"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/blocks"),
        TEXTURE_ITEMS("textures/items"),
        MODEL("models"),
        INFUSE("infuse");

        private String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

