/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.voice;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.voice.VoiceConnection;

public class VoiceServerManager {
    public Set<VoiceConnection> connections = new HashSet<VoiceConnection>();
    public ServerSocket serverSocket;
    public boolean running;
    public boolean foundLocal = false;
    public Thread listenThread;

    public void start() {
        Mekanism.logger.info("VoiceServer: Starting up server...");
        try {
            this.running = true;
            this.serverSocket = new ServerSocket(MekanismConfig.general.VOICE_PORT);
            this.listenThread = new ListenThread();
            this.listenThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            Mekanism.logger.info("VoiceServer: Shutting down server...");
            try {
                this.listenThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.foundLocal = false;
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while shutting down server.");
            e.printStackTrace();
        }
        this.running = false;
    }

    public void sendToPlayers(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (connection.getPlayer() == null) {
            return;
        }
        int channel = connection.getCurrentChannel();
        if (channel == 0) {
            return;
        }
        for (VoiceConnection iterConn : this.connections) {
            if (iterConn.getPlayer() == null || iterConn == connection || !iterConn.canListen(channel)) continue;
            iterConn.sendToPlayer(byteCount, audioData, connection);
        }
    }

    public class ListenThread
    extends Thread {
        public ListenThread() {
            this.setDaemon(true);
            this.setName("VoiceServer Listen Thread");
        }

        @Override
        public void run() {
            while (VoiceServerManager.this.running) {
                try {
                    Socket s = VoiceServerManager.this.serverSocket.accept();
                    VoiceConnection connection = new VoiceConnection(s);
                    connection.start();
                    VoiceServerManager.this.connections.add(connection);
                    Mekanism.logger.info("VoiceServer: Accepted new connection.");
                }
                catch (SocketException s) {
                }
                catch (NullPointerException s) {
                }
                catch (Exception e) {
                    Mekanism.logger.error("VoiceServer: Error while accepting connection.");
                    e.printStackTrace();
                }
            }
        }
    }
}

