/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.shadowfacts.shadowmc.util.Color;
import net.shadowfacts.shadowmc.util.MouseButton;
import org.lwjgl.opengl.GL11;

public abstract class AbstractGUI {
    protected Minecraft mc;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected float zLevel = 0.0f;
    protected AbstractGUI parent;
    protected List<AbstractGUI> children = new ArrayList<AbstractGUI>();
    protected boolean visible = true;
    protected List<String> tooltip = new ArrayList<String>();
    protected boolean initialized;

    public AbstractGUI(int x, int y, int width, int height) {
        this.mc = Minecraft.func_71410_x();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.initialized = true;
    }

    public boolean hasChildren() {
        return true;
    }

    public <T extends AbstractGUI> T addChild(T child) {
        child.parent = this;
        this.children.add(child);
        return child;
    }

    public void removeChild(AbstractGUI child) {
        this.children.remove(child);
    }

    public AbstractGUI getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean isWithinMovableBounds(int x, int y) {
        return false;
    }

    public void onMove(int mouseX, int mouseY, MouseButton mouseButton) {
    }

    protected void drawHoveringText(List<String> text, int x, int y) {
        this.getRoot().drawHoveringText(text, x, y);
    }

    protected void drawText(String text, int x, int y, Color color, boolean shadow) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.zLevel + 0.5f));
        if (shadow) {
            this.mc.field_71466_p.func_175063_a(text, (float)x, (float)y, color.toARGB());
        } else {
            this.mc.field_71466_p.func_78276_b(text, x, y, color.toARGB());
        }
        Color.WHITE.apply();
        GL11.glPopMatrix();
    }

    protected void drawText(String text, int x, int y, boolean shadow) {
        this.drawText(text, x, y, Color.WHITE, shadow);
    }

    protected void drawText(String text, int x, int y, Color color) {
        this.drawText(text, x, y, color, false);
    }

    protected void drawText(String text, int x, int y) {
        this.drawText(text, x, y, Color.WHITE);
    }

    protected void drawCenteredText(String text, int x, int maxX, int y, int maxY, Color color) {
        int centerX = x + (maxX - x) / 2 - this.mc.field_71466_p.func_78256_a(text) / 2;
        int centerY = y + (maxY - y) / 2 - this.mc.field_71466_p.field_78288_b / 2;
        this.drawText(text, centerX, centerY, color);
    }

    protected void drawCenteredText(String text, int x, int maxX, int y, int maxY) {
        this.drawCenteredText(text, x, maxX, y, maxY, Color.WHITE);
    }

    protected void bindTexture(ResourceLocation texture) {
        this.mc.func_110434_K().func_110577_a(texture);
    }

    protected void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.zLevel).func_187315_a((double)((float)u * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)v * f1)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.zLevel).func_187315_a((double)((float)u * f), (double)((float)v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawRect(int x, int y, int width, int height, Color color, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179141_d();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        color.apply();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)x, (double)y + (double)height, (double)zLevel).func_181675_d();
        buffer.func_181662_b((double)x + (double)width, (double)y + (double)height, (double)zLevel).func_181675_d();
        buffer.func_181662_b((double)x + (double)width, (double)y, (double)zLevel).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)zLevel).func_181675_d();
        tessellator.func_78381_a();
        Color.WHITE.apply();
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    protected void drawRect(int x, int y, int width, int height, Color color) {
        this.drawRect(x, y, width, height, color, this.zLevel);
    }

    @Deprecated
    protected void drawLine(int x, int y, int width, int height, float angle, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)angle, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawRect(x, y, width, height, color);
        GlStateManager.func_179121_F();
    }

    @Deprecated
    protected void drawVerticalLine(int x, int y, int width, int height, Color color) {
        this.drawLine(x, y, width, height, 45.0f, color);
    }

    @Deprecated
    protected void drawHorizontalLine(int x, int y, int width, int height, Color color) {
        this.drawLine(x, y, width, height, 0.0f, color);
    }

    protected void drawGradientRect(int x, int y, int width, int height, Color topColor, Color bottomColor) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x + (double)width, (double)y, (double)this.zLevel).func_181666_a(topColor.getRed(), topColor.getGreen(), topColor.getBlue(), topColor.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.zLevel).func_181666_a(topColor.getRed(), topColor.getGreen(), topColor.getBlue(), topColor.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)x, (double)y + (double)height, (double)this.zLevel).func_181666_a(bottomColor.getRed(), bottomColor.getRed(), bottomColor.getBlue(), bottomColor.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)x + (double)width, (double)y + (double)height, (double)this.zLevel).func_181666_a(bottomColor.getRed(), bottomColor.getRed(), bottomColor.getBlue(), bottomColor.getAlpha()).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void update() {
    }

    public abstract void draw(int var1, int var2);

    public void drawTooltip(int x, int y) {
        this.drawHoveringText(this.getTooltip(), x, y);
    }

    public void updatePosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public void onGUIClosed() {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getZLevel() {
        return this.zLevel;
    }

    public void setZLevel(float zLevel) {
        this.zLevel = zLevel;
    }

    public void setParent(AbstractGUI parent) {
        this.parent = parent;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

