/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityItemHandler
extends TileEntity
implements IItemHandlerModifiable {
    protected ItemStack[] inventory;

    public TileEntityItemHandler(int size) {
        this.inventory = new ItemStack[size];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            ItemStack stack = this.inventory[slot];
            if (stack == null) continue;
            NBTTagCompound stackTag = stack.func_77955_b(new NBTTagCompound());
            stackTag.func_74768_a("_slotNum", slot);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Inventory", (NBTBase)tagList);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = tagList.func_150305_b(i);
            int slot = stackTag.func_74762_e("_slotNum");
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    public int getSlots() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            throw new IllegalArgumentException("Invalid slot: " + slot);
        }
        return this.inventory[slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot < 0 || slot >= this.inventory.length) {
            throw new IllegalArgumentException("Invalid slot: " + slot);
        }
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        ItemStack existing = this.inventory[slot];
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (existing == null) {
                this.inventory[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot >= this.inventory.length) {
            throw new IllegalArgumentException("Invalid slot: " + slot);
        }
        if (amount == 0) {
            return null;
        }
        ItemStack existing = this.inventory[slot];
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.inventory[slot] = null;
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.inventory[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return Math.min(64, stack.func_77976_d());
    }

    protected void onContentsChanged(int slot) {
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

