/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.util;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;

public class ReflectionUtil {
    private static Map<FieldDesc, Field> fieldMap = new HashMap<FieldDesc, Field>();
    private static Map<MethodDesc, Method> methodMap = new HashMap<MethodDesc, Method>();
    private static Map<String, String> obfFieldMap = new HashMap<String, String>();
    private static Map<String, String> obfMethodMap = new HashMap<String, String>();

    private ReflectionUtil() {
    }

    public static void addObfFieldEntry(String deobf, String obf) {
        obfFieldMap.put(deobf, obf);
    }

    public static void addObfMethodEntry(String deobf, String obf) {
        obfMethodMap.put(deobf, obf);
    }

    private static void putField(String owner, String name) throws ClassNotFoundException, NoSuchFieldException {
        ReflectionUtil.putField(Class.forName(owner), name);
    }

    private static void putField(Class owner, String name) throws NoSuchFieldException {
        Field f = owner.getDeclaredField(ReflectionUtil.getFieldName(name));
        f.setAccessible(true);
        fieldMap.put(new FieldDesc(owner, name), f);
    }

    private static void putMethod(String owner, String name, Class<?> ... paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        ReflectionUtil.putMethod(Class.forName(owner), name, paramTypes);
    }

    private static void putMethod(Class<?> owner, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        Method m = owner.getDeclaredMethod(name, paramTypes);
        m.setAccessible(true);
        methodMap.put(new MethodDesc(owner, name, paramTypes), m);
    }

    private static String getFieldName(String deobfName) {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            return deobfName;
        }
        return obfFieldMap.get(deobfName);
    }

    private static String getMethodName(String deobfName) {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            return deobfName;
        }
        return obfMethodMap.get(deobfName);
    }

    public static Object get(String owner, String name, Object instance) throws ClassNotFoundException, NoSuchFieldException {
        return ReflectionUtil.get(Class.forName(owner), name, instance);
    }

    public static Object get(Class owner, String name, Object instance) throws NoSuchFieldException {
        FieldDesc desc = new FieldDesc(owner, name);
        if (!fieldMap.containsKey(desc)) {
            ReflectionUtil.putField(owner, name);
        }
        try {
            return fieldMap.get(desc).get(instance);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static int getInt(String owner, String name, Object instance) throws ClassNotFoundException, NoSuchFieldException {
        return ReflectionUtil.getInt(Class.forName(owner), name, instance);
    }

    public static int getInt(Class owner, String name, Object instance) throws NoSuchFieldException {
        FieldDesc desc = new FieldDesc(owner, name);
        if (!fieldMap.containsKey(desc)) {
            ReflectionUtil.putField(owner, name);
        }
        try {
            return fieldMap.get(desc).getInt(instance);
        }
        catch (IllegalAccessException illegalAccessException) {
            return Integer.MIN_VALUE;
        }
    }

    public static Object invoke(String owner, String name, Object instance, Class[] paramTypes, Object ... args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        return ReflectionUtil.invoke(Class.forName(owner), name, instance, paramTypes, args);
    }

    public static Object invoke(Class owner, String name, Object instance, Class[] paramTypes, Object ... args) throws NoSuchMethodException, InvocationTargetException {
        MethodDesc desc = new MethodDesc(owner, name, paramTypes);
        if (!methodMap.containsKey(desc)) {
            ReflectionUtil.putMethod(owner, name, paramTypes);
        }
        try {
            return methodMap.get(desc).invoke((Object)args, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private static class MethodDesc {
        private Class owner;
        private String name;
        private Class[] paramTypes;

        public String toString() {
            return this.owner.getName() + "." + this.name + "(" + Arrays.toString(this.paramTypes) + ")";
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof MethodDesc) {
                MethodDesc other = (MethodDesc)obj;
                return other.owner.equals(this.owner) && other.name.equals(this.name) && Arrays.equals(other.paramTypes, this.paramTypes);
            }
            return false;
        }

        @ConstructorProperties(value={"owner", "name", "paramTypes"})
        public MethodDesc(Class owner, String name, Class[] paramTypes) {
            this.owner = owner;
            this.name = name;
            this.paramTypes = paramTypes;
        }
    }

    private static class FieldDesc {
        private Class owner;
        private String name;

        public String toString() {
            return this.owner.getName() + "." + this.name;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FieldDesc) {
                FieldDesc other = (FieldDesc)obj;
                return other.owner.equals(this.owner) && other.name.equals(this.name);
            }
            return false;
        }

        @ConstructorProperties(value={"owner", "name"})
        public FieldDesc(Class owner, String name) {
            this.owner = owner;
            this.name = name;
        }
    }
}

