/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import openmods.LibConfig;
import openmods.Log;
import openmods.utils.Coord;

public class BlockDropsStore {
    public static final BlockDropsStore instance = new BlockDropsStore();
    private final TIntObjectHashMap<WorldDrops> worldDrops = new TIntObjectHashMap();

    private synchronized WorldDrops getDrops(World world) {
        if (world.field_72995_K) {
            return null;
        }
        int dimensionId = world.field_73011_w.dimensionId;
        WorldDrops result = (WorldDrops)this.worldDrops.get(dimensionId);
        if (result == null) {
            result = new WorldDrops(dimensionId);
            this.worldDrops.put(dimensionId, (Object)result);
        }
        return result;
    }

    public void storeDrops(World world, int x, int y, int z, List<ItemStack> items) {
        WorldDrops drops = this.getDrops(world);
        if (drops != null) {
            drops.storeDrops(x, y, z, items);
        }
    }

    public ArrayList<ItemStack> harvestDrops(World world, int x, int y, int z) {
        WorldDrops drops = this.getDrops(world);
        return drops != null ? drops.harvestDrops(x, y, z) : null;
    }

    public Object createForgeListener() {
        return new ForgeListener();
    }

    public Object createFmlListener() {
        return new FmlListener();
    }

    private void cleanup(World world, String location) {
        int dimensionId = world.field_73011_w.dimensionId;
        WorldDrops drops = (WorldDrops)this.worldDrops.get(dimensionId);
        if (drops != null) {
            drops.cleanup(location);
        }
    }

    public class FmlListener {
        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent evt) {
            if (evt.side == Side.SERVER && evt.phase == TickEvent.Phase.END) {
                BlockDropsStore.this.cleanup(evt.world, "tick");
            }
        }
    }

    public class ForgeListener {
        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload evt) {
            World world = evt.world;
            if (!world.field_72995_K) {
                BlockDropsStore.this.cleanup(world, "unload");
            }
        }
    }

    private static class WorldDrops {
        public final Multimap<Coord, BlockDrop> drops = ArrayListMultimap.create();
        public final int dimensionId;

        public WorldDrops(int dimensionId) {
            this.dimensionId = dimensionId;
        }

        public synchronized void storeDrops(int x, int y, int z, List<ItemStack> items) {
            this.drops.put((Object)new Coord(x, y, z), (Object)new BlockDrop(items));
        }

        public synchronized ArrayList<ItemStack> harvestDrops(int x, int y, int z) {
            Coord key = new Coord(x, y, z);
            if (this.drops.containsKey((Object)key)) {
                ArrayList result = Lists.newArrayList();
                Iterator it = this.drops.get((Object)key).iterator();
                while (it.hasNext()) {
                    BlockDrop drop = (BlockDrop)it.next();
                    result.addAll(drop.items);
                    it.remove();
                }
                return result;
            }
            return null;
        }

        public synchronized void cleanup(String location) {
            if (!this.drops.isEmpty()) {
                StringBuilder result = new StringBuilder();
                result.append(String.format("Found unharvested drops in world %d after %s\n", this.dimensionId, location));
                if (!LibConfig.dropsDebug) {
                    result.append("To enable stacktrace logging, set config option 'debug.dropsDebug' to true\n");
                }
                for (Map.Entry e : this.drops.asMap().entrySet()) {
                    result.append("Drops from location: ");
                    result.append(e.getKey());
                    result.append('\n');
                    for (BlockDrop drop : (Collection)e.getValue()) {
                        drop.logContents(result);
                    }
                }
                Log.warn("%s", result.toString());
                this.drops.clear();
            }
        }
    }

    private static class BlockDrop {
        public final Throwable location = LibConfig.dropsDebug ? new Throwable() : null;
        public final List<ItemStack> items;

        public BlockDrop(List<ItemStack> drops) {
            this.items = ImmutableList.copyOf(drops);
        }

        public void logContents(StringBuilder result) {
            result.append("\tItems: ");
            result.append(this.items.toString());
            result.append('\n');
            if (this.location != null) {
                result.append("\tLocation:\n");
                for (StackTraceElement e : this.location.getStackTrace()) {
                    result.append("\t\t");
                    result.append(e.toString());
                    result.append('\n');
                }
            }
        }
    }
}

