/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import openmods.block.IBlockRotationMode;
import openmods.block.RotationAxis;
import openmods.geometry.HalfAxis;
import openmods.geometry.LocalDirections;
import openmods.geometry.Orientation;
import openmods.utils.BlockUtils;

public enum BlockRotationMode implements IBlockRotationMode
{
    NONE(RotationAxis.NO_AXIS, new Orientation[]{Orientation.XP_YP}){

        @Override
        public boolean isOrientationValid(Orientation dir) {
            return true;
        }

        @Override
        public Orientation fromValue(int value) {
            return Orientation.XP_YP;
        }

        @Override
        public int toValue(Orientation dir) {
            return 0;
        }

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            return Orientation.XP_YP;
        }

        @Override
        public boolean toolRotationAllowed() {
            return false;
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            return null;
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return EnumFacing.NORTH;
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return EnumFacing.UP;
        }
    }
    ,
    TWO_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.ZN_YP, Orientation.XP_YP}){

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return Orientation.ZN_YP;
                }
                case NORTH: 
                case SOUTH: {
                    return Orientation.XP_YP;
                }
            }
            return null;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            return this.getOrientationFacing(player.func_174811_aO());
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            switch (axis) {
                case UP: 
                case DOWN: {
                    return currentOrientation == Orientation.ZN_YP ? Orientation.XP_YP : Orientation.ZN_YP;
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    return this.getOrientationFacing(axis);
                }
            }
            return null;
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return orientation.north();
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return orientation.up();
        }
    }
    ,
    THREE_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YP, Orientation.ZN_XN, Orientation.XP_ZN}){

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return Orientation.ZN_XN;
                }
                case NORTH: 
                case SOUTH: {
                    return Orientation.XP_ZN;
                }
            }
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            EnumFacing normalDir = BlockUtils.get3dOrientation(player, pos);
            return this.getOrientationFacing(normalDir);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            return this.getOrientationFacing(axis);
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return orientation.up();
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return orientation.south();
        }
    }
    ,
    FOUR_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YP, Orientation.ZN_YP, Orientation.XN_YP, Orientation.ZP_YP}){

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            switch (side) {
                case SOUTH: {
                    return Orientation.XN_YP;
                }
                case WEST: {
                    return Orientation.ZN_YP;
                }
                case NORTH: {
                    return Orientation.XP_YP;
                }
                case EAST: {
                    return Orientation.ZP_YP;
                }
            }
            return null;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            return this.getOrientationFacing(player.func_174811_aO().func_176734_d());
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            switch (axis) {
                case UP: {
                    return currentOrientation.rotateAround(HalfAxis.POS_Y);
                }
                case DOWN: {
                    return currentOrientation.rotateAround(HalfAxis.NEG_Y);
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    EnumFacing currentFront = this.getFront(currentOrientation);
                    EnumFacing target = currentFront == axis ? axis.func_176734_d() : axis;
                    return this.getOrientationFacing(target);
                }
            }
            return null;
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return orientation.north();
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return orientation.up();
        }
    }
    ,
    SIX_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YN, Orientation.XP_YP, Orientation.XP_ZN, Orientation.XN_ZP, Orientation.ZN_XN, Orientation.ZP_XP}){

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            switch (side) {
                case DOWN: {
                    return Orientation.XP_YN;
                }
                case EAST: {
                    return Orientation.ZP_XP;
                }
                case NORTH: {
                    return Orientation.XP_ZN;
                }
                case SOUTH: {
                    return Orientation.XN_ZP;
                }
                case WEST: {
                    return Orientation.ZN_XN;
                }
            }
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            return this.getOrientationFacing(BlockUtils.get3dOrientation(player, pos).func_176734_d());
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            EnumFacing currentFront = this.getFront(currentOrientation);
            EnumFacing target = currentFront == axis ? axis.func_176734_d() : axis;
            return this.getOrientationFacing(target);
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return orientation.up();
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return orientation.south();
        }
    }
    ,
    THREE_FOUR_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YP, Orientation.XN_YP, Orientation.ZP_YP, Orientation.ZN_YP, Orientation.YP_XN, Orientation.YN_XN, Orientation.ZP_XN, Orientation.ZN_XN, Orientation.XP_ZN, Orientation.XN_ZN, Orientation.YP_ZN, Orientation.YN_ZN}){

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return Orientation.ZN_XN;
                }
                case NORTH: 
                case SOUTH: {
                    return Orientation.XP_ZN;
                }
            }
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            return this.getOrientationFacing(BlockUtils.get3dOrientation(player, pos));
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            HalfAxis currentTop;
            HalfAxis newTop = HalfAxis.fromEnumFacing(axis);
            if (newTop == (currentTop = currentOrientation.y)) {
                return currentOrientation.rotateAround(HalfAxis.POS_Y);
            }
            if (newTop == currentTop.negate()) {
                return currentOrientation.rotateAround(HalfAxis.NEG_Y);
            }
            return this.getOrientationFacing(axis);
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return orientation.up();
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return orientation.south();
        }
    }
    ,
    TWELVE_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_Z), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_Z), Orientation.lookupYZ(HalfAxis.NEG_Z, HalfAxis.POS_Y), Orientation.lookupYZ(HalfAxis.POS_Z, HalfAxis.POS_Y), Orientation.lookupYZ(HalfAxis.NEG_X, HalfAxis.POS_Y), Orientation.lookupYZ(HalfAxis.POS_X, HalfAxis.POS_Y), Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.POS_Z), Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_X), Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.POS_X), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.NEG_Z), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_X), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.NEG_X)}){

        public Orientation directionToOrientation(EnumFacing localTop) {
            switch (localTop) {
                case DOWN: {
                    return Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_Z);
                }
                case EAST: {
                    return Orientation.lookupYZ(HalfAxis.POS_X, HalfAxis.POS_Y);
                }
                case NORTH: {
                    return Orientation.lookupYZ(HalfAxis.NEG_Z, HalfAxis.POS_Y);
                }
                case SOUTH: {
                    return Orientation.lookupYZ(HalfAxis.POS_Z, HalfAxis.POS_Y);
                }
                case WEST: {
                    return Orientation.lookupYZ(HalfAxis.NEG_X, HalfAxis.POS_Y);
                }
            }
            return Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_Z);
        }

        @Override
        public Orientation getOrientationFacing(EnumFacing side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(BlockPos pos, EntityLivingBase player) {
            EnumFacing player3d = BlockUtils.get3dOrientation(player, pos).func_176734_d();
            if (player3d.equals((Object)EnumFacing.UP)) {
                EnumFacing player2d = player.func_174811_aO().func_176734_d();
                return Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.fromEnumFacing(player2d));
            }
            if (player3d.equals((Object)EnumFacing.DOWN)) {
                EnumFacing player2d = player.func_174811_aO().func_176734_d();
                return Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.fromEnumFacing(player2d));
            }
            return Orientation.lookupYZ(HalfAxis.fromEnumFacing(player3d), HalfAxis.POS_Y);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, EnumFacing axis) {
            switch (axis) {
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    EnumFacing currentFront = this.getFront(currentOrientation);
                    EnumFacing target = currentFront == axis ? axis.func_176734_d() : axis;
                    return Orientation.lookupYZ(HalfAxis.fromEnumFacing(target), HalfAxis.POS_Y);
                }
                case UP: {
                    if (currentOrientation.y != HalfAxis.POS_Y) {
                        return Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_Z);
                    }
                    return currentOrientation.rotateAround(HalfAxis.POS_Y);
                }
                case DOWN: {
                    if (currentOrientation.y != HalfAxis.NEG_Y) {
                        return Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_Z);
                    }
                    return currentOrientation.rotateAround(HalfAxis.POS_Y);
                }
            }
            return null;
        }

        @Override
        public EnumFacing getFront(Orientation orientation) {
            return orientation.up();
        }

        @Override
        public EnumFacing getTop(Orientation orientation) {
            return orientation.south();
        }
    };

    private static final int MAX_ORIENTATIONS = 16;
    private final Orientation[] idToOrientation;
    private final int[] orientationToId;
    private final EnumFacing[] rotationAxes;
    private final Set<Orientation> validDirections;
    private final int bitCount;
    private final int mask;
    private final PropertyEnum<Orientation> property;

    private BlockRotationMode(EnumFacing[] rotations, Orientation ... validOrientations) {
        this.rotationAxes = rotations;
        this.validDirections = ImmutableSet.copyOf((Object[])validOrientations);
        int count = validOrientations.length;
        Preconditions.checkArgument((this.validDirections.size() == count ? 1 : 0) != 0, (Object)"Duplicated directions");
        Preconditions.checkArgument((count <= 16 ? 1 : 0) != 0, (String)"Too many values: %s", (Object[])new Object[]{count});
        this.property = PropertyEnum.func_177707_a((String)"orientation", Orientation.class, this.validDirections);
        this.idToOrientation = new Orientation[16];
        this.orientationToId = new int[Orientation.VALUES.length];
        int i = 0;
        while (i < count) {
            Orientation orientation = validOrientations[i];
            Preconditions.checkNotNull((Object)((Object)orientation));
            this.idToOrientation[i] = orientation;
            this.orientationToId[orientation.ordinal()] = i++;
        }
        if (count == 0) {
            this.bitCount = 0;
            this.mask = 0;
        } else {
            int maxValue = count - 1;
            this.bitCount = 32 - Integer.numberOfLeadingZeros(maxValue);
            this.mask = (1 << this.bitCount) - 1;
            for (int i2 = count; i2 < this.idToOrientation.length; ++i2) {
                this.idToOrientation[i2] = this.idToOrientation[0];
            }
        }
    }

    @Override
    public Orientation fromValue(int value) {
        try {
            return this.idToOrientation[value];
        }
        catch (IndexOutOfBoundsException e) {
            return this.idToOrientation[0];
        }
    }

    @Override
    public int toValue(Orientation dir) {
        try {
            return this.orientationToId[dir.ordinal()];
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    @Override
    public boolean isOrientationValid(Orientation dir) {
        return this.validDirections.contains((Object)dir);
    }

    @Override
    public boolean toolRotationAllowed() {
        return true;
    }

    @Override
    public LocalDirections getLocalDirections(Orientation orientation) {
        return LocalDirections.fromFrontAndTop(this.getFront(orientation), this.getTop(orientation));
    }

    @Override
    public IProperty<Orientation> getProperty() {
        return this.property;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public EnumFacing[] getToolRotationAxes() {
        return this.rotationAxes;
    }

    @Override
    public Set<Orientation> getValidDirections() {
        return this.validDirections;
    }
}

