/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.block.BlockRotationMode;
import openmods.geometry.HalfAxis;
import openmods.geometry.Orientation;

public class RotationHelper {
    private final BlockRotationMode mode;
    private final int originalMeta;
    private Orientation orientation;
    private final World world;
    private final int x;
    private final int y;
    private final int z;

    public RotationHelper(BlockRotationMode mode, World world, int x, int y, int z) {
        this.mode = mode;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        int meta = world.getBlockMetadata(x, y, z);
        this.originalMeta = meta & ~mode.mask;
        int dirPart = meta & mode.mask;
        this.orientation = mode.fromValue(dirPart);
    }

    public boolean rotateWithTool(ForgeDirection axis) {
        if (this.mode == BlockRotationMode.NONE) {
            return false;
        }
        Orientation newOrientation = this.mode.calculateToolRotation(this.orientation, axis);
        if (newOrientation != null) {
            if (this.mode.isPlacementValid(newOrientation)) {
                return this.setOrientation(newOrientation);
            }
            Log.info("Invalid tool rotation: [%s] %s: (%d,%d,%d): %s->%s", new Object[]{this.mode, axis, this.x, this.y, this.z, this.orientation, newOrientation});
        }
        return false;
    }

    public boolean rotateAroundAxis(HalfAxis axis) {
        if (this.mode == BlockRotationMode.NONE) {
            return false;
        }
        Orientation newOrientation = this.orientation.rotateAround(axis);
        if (newOrientation != null) {
            if (this.mode.isPlacementValid(newOrientation)) {
                return this.setOrientation(newOrientation);
            }
            Log.info("Invalid rotation: [%s] %s: (%d,%d,%d): %s->%s", new Object[]{this.mode, axis, this.x, this.y, this.z, this.orientation, newOrientation});
        }
        return false;
    }

    public boolean setOrientation(Orientation newOrientation) {
        if (newOrientation == this.orientation) {
            return false;
        }
        if (this.mode.isPlacementValid(newOrientation)) {
            int dirPart = this.mode.toValue(newOrientation);
            int newMeta = this.originalMeta | dirPart;
            this.world.setBlockMetadataWithNotify(this.x, this.y, this.z, newMeta, 3);
            this.orientation = newOrientation;
            return true;
        }
        Log.info("Invalid orientation change: [%s] (%d,%d,%d): %s->%s", new Object[]{this.mode, this.x, this.y, this.z, this.orientation, newOrientation});
        return false;
    }
}

