/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import info.openmods.calc.ExprType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import openmods.calc.CalcState;
import openmods.calc.CommandExecutionException;
import openmods.calc.CommandSyntaxException;
import openmods.calc.ICommandComponent;
import openmods.calc.IWhitespaceSplitter;
import openmods.calc.MapCommandComponent;
import openmods.calc.TerminalCommandComponent;
import openmods.calc.WhitespaceSplitters;
import openmods.config.simpler.ConfigurableClassAdapter;
import openmods.utils.CommandUtils;
import openmods.utils.StackUnderflowException;

public class CommandCalcFactory {
    private final File scriptDir;
    private final CalcState state = new CalcState();
    private final ICommandComponent root = MapCommandComponent.builder().put("config", MapCommandComponent.builder().put("new", new TerminalCommandComponent(Arrays.toString((Object[])CalcState.CalculatorType.values())){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String type = args.getNextPart().toUpperCase(Locale.ROOT);
            try {
                CalcState.CalculatorType newType = CalcState.CalculatorType.valueOf(type);
                CommandCalcFactory.this.state.createCalculator(newType);
            }
            catch (IllegalArgumentException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_invalid_type", Joiner.on((char)',').join((Object[])CalcState.CalculatorType.values()));
            }
        }

        @Override
        public List<String> getTabCompletions(IWhitespaceSplitter args) {
            String type = args.getNextPart();
            CalcState.CalculatorType[] values = CalcState.CalculatorType.values();
            Iterable types = CommandCalcFactory.stringifyList((Object[])values);
            return CommandUtils.filterPrefixes(type, types);
        }
    }).put("load", new TerminalCommandComponent("<name>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            try {
                CommandCalcFactory.this.state.loadCalculator(args.getNextPart());
            }
            catch (CalcState.NoSuchNameException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_invalid_name", new Object[0]);
            }
        }

        @Override
        public List<String> getTabCompletions(IWhitespaceSplitter args) {
            String name = args.getNextPart();
            return CommandUtils.filterPrefixes(name, CommandCalcFactory.this.state.getCalculatorsNames());
        }
    }).put("store", new TerminalCommandComponent("<name>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            CommandCalcFactory.this.state.nameCalculator(args.getNextPart());
        }
    }).put("pop", new TerminalCommandComponent(""){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            int size = CommandCalcFactory.this.state.pushCalculator();
            CommandUtils.respond(sender, "openmodslib.command.calc_after_push", size);
        }
    }).put("push", new TerminalCommandComponent(""){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            try {
                int size = CommandCalcFactory.this.state.popCalculator();
                CommandUtils.respond(sender, "openmodslib.command.calc_after_pop", size);
            }
            catch (StackUnderflowException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_stack_underflow", new Object[0]);
            }
        }
    }).put("set", new TerminalCommandComponent("<key> <value>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String key = args.getNextPart();
            String value = args.getTail();
            try {
                CommandCalcFactory.this.state.getActiveCalculator().setProperty(key, value);
            }
            catch (ConfigurableClassAdapter.NoSuchPropertyException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_invalid_key", new Object[0]);
            }
            catch (Exception e) {
                throw new CommandSyntaxException("openmodslib.command.calc_cant_set", new Object[0]);
            }
        }

        @Override
        public List<String> getTabCompletions(IWhitespaceSplitter args) {
            String key = args.getNextPart();
            if (!args.isFinished()) {
                return Lists.newArrayList();
            }
            return CommandUtils.filterPrefixes(key, CommandCalcFactory.this.state.getActiveCalculator().getProperties());
        }
    }).put("get", new TerminalCommandComponent("<key>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String key = args.getNextPart();
            try {
                CommandCalcFactory.this.state.getActiveCalculator().getProperty(key);
            }
            catch (ConfigurableClassAdapter.NoSuchPropertyException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_invalid_key", new Object[0]);
            }
        }

        @Override
        public List<String> getTabCompletions(IWhitespaceSplitter args) {
            String key = args.getNextPart();
            return CommandUtils.filterPrefixes(key, CommandCalcFactory.this.state.getActiveCalculator().getProperties());
        }
    }).put("mode", new TerminalCommandComponent(Arrays.toString(ExprType.values())){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String type = args.getNextPart().toUpperCase(Locale.ROOT);
            try {
                ((CommandCalcFactory)CommandCalcFactory.this).state.exprType = ExprType.valueOf((String)type);
            }
            catch (IllegalArgumentException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_invalid_mode", Joiner.on((char)',').join((Object[])ExprType.values()));
            }
        }
    }).build()).put("execute", new TerminalCommandComponent("<path>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String path = args.getNextPart();
            File scriptFile = new File(CommandCalcFactory.this.scriptDir, path).getAbsoluteFile();
            if (!CommandCalcFactory.checkIsParent(CommandCalcFactory.this.scriptDir, scriptFile)) {
                throw new CommandExecutionException("openmodslib.command.calc_not_child", scriptFile, CommandCalcFactory.this.scriptDir);
            }
            if (!scriptFile.isFile()) {
                throw new CommandExecutionException("openmodslib.command.calc_not_file", scriptFile);
            }
            int count = CommandCalcFactory.this.executeScript(sender, scriptFile);
            CommandUtils.respond(sender, "openmodslib.command.calc_executed_count", count);
        }

        @Override
        public List<String> getTabCompletions(IWhitespaceSplitter args) {
            File fileToScan;
            String path = args.getNextPart().replace("\\", "/");
            File scriptFile = new File(CommandCalcFactory.this.scriptDir, path).getAbsoluteFile();
            File file = fileToScan = path.isEmpty() || path.endsWith("/") ? scriptFile : scriptFile.getParentFile();
            if (!fileToScan.isDirectory()) {
                return null;
            }
            int parentLengthPath = CommandCalcFactory.this.scriptDir.getAbsolutePath().length() + 1;
            ArrayList propositions = Lists.newArrayList();
            for (File child : fileToScan.listFiles()) {
                if (child.isFile()) {
                    propositions.add(child.getAbsolutePath().substring(parentLengthPath).replace("\\", "/"));
                    continue;
                }
                if (!child.isDirectory()) continue;
                propositions.add(child.getAbsolutePath().substring(parentLengthPath).replace("\\", "/") + "/");
            }
            return CommandUtils.filterPrefixes(path, propositions);
        }
    }).put("let", new TerminalCommandComponent("<name> <initializer expression>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String name = args.getNextPart();
            String expr = args.getTail();
            Object result = CommandCalcFactory.this.state.compileAndSetGlobalSymbol(sender, name, expr);
            CommandUtils.respond(sender, "openmodslib.command.calc_set", name, String.valueOf(result));
        }
    }).put("fun", new TerminalCommandComponent("<name> <arg count> <function body>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            int argCount;
            String name = args.getNextPart();
            String argCountStr = args.getNextPart();
            try {
                argCount = Integer.parseInt(argCountStr);
            }
            catch (NumberFormatException e) {
                throw new CommandSyntaxException("openmodslib.command.calc_invalid_number", argCountStr);
            }
            String expr = args.getTail();
            CommandCalcFactory.this.state.compileAndDefineGlobalFunction(sender, name, argCount, expr);
            CommandUtils.respond(sender, "openmodslib.command.calc_function_defined", name);
        }
    }).put("eval", new TerminalCommandComponent("<expression>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            String expr = args.getTail();
            if (((CommandCalcFactory)CommandCalcFactory.this).state.exprType.hasSingleResult) {
                String result = CommandCalcFactory.this.state.compileExecuteAndPrint(sender, expr);
                CommandUtils.respondText(sender, result);
            } else {
                CommandCalcFactory.this.state.compileAndExecute(sender, expr);
                CommandUtils.respond(sender, "openmodslib.command.calc_stack_size", ((CommandCalcFactory)CommandCalcFactory.this).state.getActiveCalculator().environment.topFrame().stack().size());
            }
        }
    }).put("echo", new TerminalCommandComponent("<str>"){

        @Override
        public void execute(ICommandSender sender, IWhitespaceSplitter args) {
            sender.func_145747_a((ITextComponent)new TextComponentString(args.getTail()));
        }
    }).build();

    public CommandCalcFactory(File scriptDir) {
        this.scriptDir = scriptDir.getAbsoluteFile();
    }

    public ICommandComponent getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeScript(ICommandSender sender, File scriptFile) {
        int count = 0;
        try {
            Closer closer = Closer.create();
            try {
                String line;
                Reader r = (Reader)closer.register((Closeable)new FileReader(scriptFile));
                BufferedReader br = (BufferedReader)closer.register((Closeable)new BufferedReader(r));
                while ((line = br.readLine()) != null) {
                    IWhitespaceSplitter args = WhitespaceSplitters.fromString(line);
                    this.root.execute(sender, args);
                    ++count;
                }
            }
            finally {
                closer.close();
            }
            return count;
        }
        catch (Exception e) {
            throw new CommandExecutionException(e);
        }
    }

    private static boolean checkIsParent(File dir, File target) {
        if (!dir.exists()) {
            return false;
        }
        try {
            File canonicalDir = dir.getCanonicalFile();
            while (target != null) {
                if (canonicalDir.equals(target)) {
                    return true;
                }
                target = target.getParentFile();
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
        return false;
    }

    private static Iterable<String> stringifyList(Object ... values) {
        return Iterables.transform(Arrays.asList(values), (Function)new Function<Object, String>(){

            @Nullable
            public String apply(@Nullable Object input) {
                return String.valueOf(input).toLowerCase(Locale.ROOT);
            }
        });
    }
}

