/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.command;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import openmods.Log;
import openmods.calc.command.HelpPrinter;
import openmods.calc.command.ICommandComponent;
import openmods.calc.command.IWhitespaceSplitter;
import openmods.calc.command.NestedCommandException;
import openmods.calc.command.WhitespaceSplitters;

public class CommandCalc
implements ICommand {
    protected final String name;
    private final ICommandComponent commandComponent;
    private final List<String> aliases;

    public CommandCalc(ICommandComponent parentCommandComponent, String name, String ... aliases) {
        this.name = "=" + name;
        this.aliases = Arrays.asList(aliases);
        this.commandComponent = parentCommandComponent.partialyExecute(WhitespaceSplitters.fromSplitArray(name));
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return this.name;
    }

    public List<?> func_71514_a() {
        return this.aliases;
    }

    public boolean canCommandSenderUseCommand(ICommandSender sender) {
        return true;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        HelpPrinter printer = new HelpPrinter();
        printer.push(this.name);
        this.commandComponent.help(printer);
        return printer.generate();
    }

    public List<?> addTabCompletionOptions(ICommandSender sender, String[] args) {
        return this.commandComponent.getTabCompletions(WhitespaceSplitters.fromSplitArray(args));
    }

    public void processCommand(ICommandSender sender, String[] args) {
        IWhitespaceSplitter splitArgs = WhitespaceSplitters.fromSplitArray(args);
        try {
            this.commandComponent.execute(sender, splitArgs);
        }
        catch (NestedCommandException e) {
            e.pushCommandName(this.name);
            IChatComponent message = e.getChatComponent();
            message.getChatStyle().setColor(EnumChatFormatting.RED);
            sender.addChatMessage(message);
        }
        catch (Exception e) {
            Log.info(e, "Failed to execute command", new Object[0]);
            ArrayList causes = Lists.newArrayList();
            for (Throwable current = e; current != null; current = current.getCause()) {
                causes.add(Strings.nullToEmpty((String)current.getMessage()));
            }
            throw new CommandException("openmodslib.command.calc_error", new Object[]{Joiner.on((String)"', caused by '").join((Iterable)causes)});
        }
        if (!splitArgs.isFinished()) {
            throw new CommandException("openmodslib.command.calc_extra_args", new Object[]{splitArgs.getTail()});
        }
    }
}

