/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import openmods.calc.parsing.IAstParser;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IModifierStateTransition;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.SymbolCallNode;
import openmods.utils.CollectionUtils;

public class MappedCompilerState<E>
implements ICompilerState<E> {
    private final IAstParser<E> parser;
    private final Map<String, ISymbolCallStateTransition<E>> symbolTransitions = Maps.newHashMap();
    private final Map<String, IModifierStateTransition<E>> modifierTransitions = Maps.newHashMap();

    public MappedCompilerState(IAstParser<E> parser) {
        this.parser = parser;
    }

    @Override
    public IAstParser<E> getParser() {
        return this.parser;
    }

    @Override
    public ISymbolCallStateTransition<E> getStateForSymbolCall(String symbol) {
        ISymbolCallStateTransition<E> stateTransition = this.symbolTransitions.get(symbol);
        return stateTransition != null ? stateTransition : this.createDefaultSymbolCallStateTransition(symbol);
    }

    protected ISymbolCallStateTransition<E> createDefaultSymbolCallStateTransition(final String symbol) {
        return new ISymbolCallStateTransition<E>(){

            @Override
            public ICompilerState<E> getState() {
                return MappedCompilerState.this;
            }

            @Override
            public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
                return MappedCompilerState.this.createDefaultSymbolNode(symbol, children);
            }
        };
    }

    protected IExprNode<E> createDefaultSymbolNode(String symbol, List<IExprNode<E>> children) {
        return new SymbolCallNode<E>(symbol, children);
    }

    @Override
    public IModifierStateTransition<E> getStateForModifier(String modifier) {
        IModifierStateTransition<E> stateTransition = this.modifierTransitions.get(modifier);
        return stateTransition != null ? stateTransition : this.createDefaultModifierStateTransition(modifier);
    }

    private IModifierStateTransition<E> createDefaultModifierStateTransition(String modifier) {
        throw new UnsupportedOperationException(modifier);
    }

    public MappedCompilerState<E> addStateTransition(String symbol, ISymbolCallStateTransition<E> transition) {
        CollectionUtils.putOnce(this.symbolTransitions, symbol, transition);
        return this;
    }

    public MappedCompilerState<E> addStateTransition(String symbol, IModifierStateTransition<E> transition) {
        CollectionUtils.putOnce(this.modifierTransitions, symbol, transition);
        return this;
    }
}

