/*
 * Decompiled with CFR 0.152.
 */
package openmods.core;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.minecraft.launchwrapper.LaunchClassLoader;
import openmods.Log;
import openmods.utils.io.Locks;

public class BundledJarUnpacker {
    private static final String JAR_JARS_ATTRIBUTE = "JarJars";

    private static Locks.ExclusiveLock findLockableFile(File dir, String name) throws IOException {
        for (int i = 0; i < 1000; ++i) {
            File file;
            Optional<Locks.ExclusiveLock> lock;
            File subDir = new File(dir, Integer.toString(i));
            if (subDir.isFile() || !subDir.exists() && !subDir.mkdirs() || !(lock = Locks.tryExclusiveLock(file = new File(subDir, name))).isPresent()) continue;
            return (Locks.ExclusiveLock)lock.get();
        }
        throw new IllegalStateException("Failed to find temporary dir for libs in " + dir);
    }

    public static void setup(Map<String, Object> data) {
        try {
            File coremodFile = (File)data.get("coremodLocation");
            if (coremodFile == null) {
                return;
            }
            LaunchClassLoader classLoader = (LaunchClassLoader)data.get("classLoader");
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            File libDir = new File(tmpDir, "mc_libs");
            if (!libDir.exists()) {
                libDir.mkdir();
            }
            JarFile coremodJar = new JarFile(coremodFile);
            final Closer closer = Closer.create();
            try {
                String jarJars = coremodJar.getManifest().getMainAttributes().getValue(JAR_JARS_ATTRIBUTE);
                if (!Strings.isNullOrEmpty((String)jarJars)) {
                    for (String jarJar : Splitter.on((String)" ").split((CharSequence)jarJars)) {
                        ZipEntry entry = coremodJar.getEntry(jarJar);
                        if (entry == null) {
                            throw new IllegalAccessException("Can't find entry " + jarJar + " in jar " + coremodFile);
                        }
                        Locks.ExclusiveLock lockedFile = BundledJarUnpacker.findLockableFile(libDir, jarJar);
                        Log.debug("Copying file %s from %s to %s", jarJar, coremodFile, lockedFile.file);
                        ReadableByteChannel jarJarStream = Channels.newChannel(coremodJar.getInputStream(entry));
                        ByteStreams.copy((ReadableByteChannel)jarJarStream, (WritableByteChannel)lockedFile.channel);
                        jarJarStream.close();
                        Locks.SharedLock sharedFile = (Locks.SharedLock)closer.register((Closeable)lockedFile.degrade());
                        sharedFile.file.deleteOnExit();
                        classLoader.addURL(sharedFile.file.toURI().toURL());
                    }
                }
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                coremodJar.close();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        closer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to inject dependecies, data: " + data.toString(), e);
        }
    }
}

