/*
 * Decompiled with CFR 0.152.
 */
package openmods.datastore;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import openmods.datastore.DataStore;
import openmods.datastore.DataStoreWrapper;
import openmods.utils.ByteUtils;
import openmods.utils.io.IStreamReader;

public class DataStoreReader<K, V> {
    private final IStreamReader<K> keyReader;
    private final IStreamReader<V> valueReader;
    private final DataStoreWrapper<K, V> wrapper;

    DataStoreReader(DataStoreWrapper<K, V> wrapper, IStreamReader<K> keyReader, IStreamReader<V> valueReader) {
        this.keyReader = keyReader;
        this.valueReader = valueReader;
        this.wrapper = wrapper;
    }

    public void read(DataInput input) {
        int size = ByteUtils.readVLI(input);
        HashMap values = Maps.newHashMap();
        try {
            for (int i = 0; i < size; ++i) {
                Object key = this.keyReader.readFromStream(input);
                Object value = this.valueReader.readFromStream(input);
                values.put(key, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataStore result = new DataStore(values);
        this.wrapper.activateData(result);
    }
}

