/*
 * Decompiled with CFR 0.152.
 */
package openmods.fakeplayer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.world.DropCapture;

public class BreakBlockAction
implements FakePlayerPool.PlayerUserReturning<List<EntityItem>> {
    private final World worldObj;
    private final BlockPos blockPos;
    private ItemStack stackToUse;

    public BreakBlockAction(World worldObj, BlockPos blockPos) {
        this.worldObj = worldObj;
        this.blockPos = blockPos;
        this.stackToUse = new ItemStack(Items.field_151046_w, 0, 0);
    }

    public BreakBlockAction setStackToUse(ItemStack stack) {
        this.stackToUse = stack;
        return this;
    }

    private boolean removeBlock(EntityPlayer player, BlockPos pos, IBlockState state, boolean canHarvest) {
        Block block = state.func_177230_c();
        block.func_176208_a(this.worldObj, pos, state, player);
        boolean result = block.removedByPlayer(state, this.worldObj, pos, player, canHarvest);
        if (result) {
            block.func_176206_d(this.worldObj, pos, state);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EntityItem> usePlayer(OpenModsFakePlayer fakePlayer) {
        List<EntityItem> drops;
        fakePlayer.field_71071_by.field_70461_c = 0;
        fakePlayer.field_71071_by.func_70299_a(0, this.stackToUse);
        if (!this.worldObj.func_175660_a((EntityPlayer)fakePlayer, this.blockPos)) {
            return Lists.newArrayList();
        }
        IBlockState state = this.worldObj.func_180495_p(this.blockPos);
        DropCapture.CaptureContext dropsCapturer = DropCapture.instance.start(this.blockPos);
        try {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.worldObj, this.blockPos, state, (EntityPlayer)fakePlayer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            TileEntity te = this.worldObj.func_175625_s(this.blockPos);
            boolean canHarvest = state.func_177230_c().canHarvestBlock((IBlockAccess)this.worldObj, this.blockPos, (EntityPlayer)fakePlayer);
            boolean isRemoved = this.removeBlock((EntityPlayer)fakePlayer, this.blockPos, state, canHarvest);
            if (isRemoved && canHarvest) {
                state.func_177230_c().func_180657_a(this.worldObj, (EntityPlayer)fakePlayer, this.blockPos, state, te, this.stackToUse);
                this.worldObj.func_180498_a((EntityPlayer)fakePlayer, 2001, this.blockPos, Block.func_176210_f((IBlockState)state));
            }
        }
        finally {
            List<EntityItem> drops2 = dropsCapturer.stop();
        }
        return drops;
    }
}

