/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Preconditions;
import java.util.Arrays;

public class Permutation2d {
    public final int width;
    public final int height;
    private final int[] permutation;

    public Permutation2d(int width, int height, int ... permutation) {
        Preconditions.checkArgument((permutation.length == width * height ? 1 : 0) != 0, (String)"Not enough points: %s != %s*%s", (Object[])new Object[]{permutation.length, width, height});
        this.width = width;
        this.height = height;
        this.permutation = permutation;
    }

    public int apply(int index) {
        return this.permutation[index];
    }

    public Permutation2d compose(Permutation2d inner) {
        Preconditions.checkArgument((inner.width == this.width ? 1 : 0) != 0, (String)"Incompatible width: %s != %s", (Object[])new Object[]{this.width, inner.width});
        Preconditions.checkArgument((inner.height == this.height ? 1 : 0) != 0, (String)"Incompatible height: %s != %s", (Object[])new Object[]{this.height, inner.height});
        int count = this.permutation.length;
        int[] newPermutation = new int[count];
        for (int i = 0; i < count; ++i) {
            int innerTransform;
            int outerTransfrom = this.permutation[i];
            newPermutation[i] = innerTransform = inner.permutation[outerTransfrom];
        }
        return new Permutation2d(this.width, this.height, newPermutation);
    }

    public static Permutation2d identity(int width, int height) {
        int[] permutation = new int[width * height];
        for (int i = 0; i < width * height; ++i) {
            permutation[i] = i;
        }
        return new Permutation2d(width, height, permutation);
    }

    public Permutation2d mirrorVertical() {
        int[] newPermutation = new int[this.width * this.height];
        int index = 0;
        for (int row = 0; row < this.height; ++row) {
            for (int column = this.width - 1; column >= 0; --column) {
                newPermutation[index++] = this.permutation[row * this.width + column];
            }
        }
        return new Permutation2d(this.width, this.height, newPermutation);
    }

    public Permutation2d mirrorHorizontal() {
        int[] newPermutation = new int[this.width * this.height];
        int index = 0;
        for (int row = this.height - 1; row >= 0; --row) {
            for (int column = 0; column < this.width; ++column) {
                newPermutation[index++] = this.permutation[row * this.width + column];
            }
        }
        return new Permutation2d(this.width, this.height, newPermutation);
    }

    public Permutation2d transpose() {
        int[] newPermutation = new int[this.width * this.height];
        int index = 0;
        for (int row = 0; row < this.width; ++row) {
            for (int column = 0; column < this.height; ++column) {
                newPermutation[index++] = this.permutation[column * this.width + row];
            }
        }
        return new Permutation2d(this.height, this.width, newPermutation);
    }

    public Permutation2d rotateCW() {
        return this.transpose().mirrorVertical();
    }

    public Permutation2d rotateCCW() {
        return this.transpose().mirrorHorizontal();
    }

    public Permutation2d reverse() {
        return this.mirrorHorizontal().mirrorVertical();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + Arrays.hashCode(this.permutation);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Permutation2d) {
            Permutation2d other = (Permutation2d)obj;
            return this.width == other.width && this.height == other.height && Arrays.equals(this.permutation, other.permutation);
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (int row = 0; row < this.height; ++row) {
            result.append('[');
            for (int column = 0; column < this.width; ++column) {
                result.append(this.permutation[index++]);
                if (column == this.width - 1) continue;
                result.append(' ');
            }
            result.append(']');
        }
        return result.toString();
    }
}

