/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import openmods.api.IInventoryCallback;
import openmods.utils.OptionalInt;

public class GenericInventory
implements IInventory {
    public static final String TAG_SLOT = "Slot";
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SIZE = "size";
    protected List<IInventoryCallback> callbacks = new ArrayList<IInventoryCallback>();
    protected String inventoryTitle;
    protected int slotsCount;
    protected ItemStack[] inventoryContents;
    protected boolean isInvNameLocalized;
    private IItemHandlerModifiable handler;

    public GenericInventory(String name, boolean isInvNameLocalized, int size) {
        this.isInvNameLocalized = isInvNameLocalized;
        this.slotsCount = size;
        this.inventoryTitle = name;
        this.inventoryContents = new ItemStack[size];
    }

    public GenericInventory addCallback(IInventoryCallback callback) {
        this.callbacks.add(callback);
        return this;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventoryContents[index] != null) {
            if (this.inventoryContents[index].field_77994_a <= count) {
                ItemStack itemstack = this.inventoryContents[index];
                this.inventoryContents[index] = null;
                this.onInventoryChanged(index);
                return itemstack;
            }
            ItemStack itemstack = this.inventoryContents[index].func_77979_a(count);
            if (this.inventoryContents[index].field_77994_a == 0) {
                this.inventoryContents[index] = null;
            }
            this.onInventoryChanged(index);
            return itemstack;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.slotsCount;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryContents[i];
    }

    public ItemStack getStackInSlot(Enum<?> i) {
        return this.func_70301_a(i.ordinal());
    }

    public ItemStack func_70304_b(int slot) {
        if (slot >= this.inventoryContents.length) {
            return null;
        }
        if (this.inventoryContents[slot] != null) {
            ItemStack itemstack = this.inventoryContents[slot];
            this.inventoryContents[slot] = null;
            this.onInventoryChanged(slot);
            return itemstack;
        }
        return null;
    }

    public boolean isItem(int slot, Item item) {
        return this.inventoryContents[slot] != null && this.inventoryContents[slot].func_77973_b() == item;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void onInventoryChanged(int slotNumber) {
        this.onInventoryChanged(OptionalInt.of(slotNumber));
    }

    public void onInventoryChanged(OptionalInt slotNumber) {
        for (IInventoryCallback callback : this.callbacks) {
            callback.onInventoryChanged(this, slotNumber);
        }
    }

    public void clearAndSetSlotCount(int amount) {
        this.slotsCount = amount;
        this.inventoryContents = new ItemStack[amount];
        this.onInventoryChanged(OptionalInt.ABSENT);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventoryContents.length; ++i) {
            this.inventoryContents[i] = null;
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.readFromNBT(tag, true);
    }

    public void readFromNBT(NBTTagCompound tag, boolean readSize) {
        if (readSize && tag.func_74764_b(TAG_SIZE)) {
            this.slotsCount = tag.func_74762_e(TAG_SIZE);
        }
        NBTTagList nbttaglist = tag.func_150295_c(TAG_ITEMS, 10);
        this.inventoryContents = new ItemStack[this.slotsCount];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stacktag = nbttaglist.func_150305_b(i);
            byte j = stacktag.func_74771_c(TAG_SLOT);
            if (j < 0 || j >= this.inventoryContents.length) continue;
            this.inventoryContents[j] = ItemStack.func_77949_a((NBTTagCompound)stacktag);
        }
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryContents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.onInventoryChanged(i);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a(TAG_SIZE, this.func_70302_i_());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryContents.length; ++i) {
            if (this.inventoryContents[i] == null) continue;
            NBTTagCompound stacktag = new NBTTagCompound();
            this.inventoryContents[i].func_77955_b(stacktag);
            stacktag.func_74774_a(TAG_SLOT, (byte)i);
            nbttaglist.func_74742_a((NBTBase)stacktag);
        }
        tag.func_74782_a(TAG_ITEMS, (NBTBase)nbttaglist);
    }

    public void func_70296_d() {
        this.onInventoryChanged(OptionalInt.ABSENT);
    }

    public void copyFrom(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (i >= this.func_70302_i_()) continue;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack != null) {
                this.func_70299_a(i, stack.func_77946_l());
                continue;
            }
            this.func_70299_a(i, null);
        }
    }

    public List<ItemStack> contents() {
        return Arrays.asList(this.inventoryContents);
    }

    public String func_70005_c_() {
        return this.inventoryTitle;
    }

    public boolean func_145818_k_() {
        return this.isInvNameLocalized;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ITextComponent func_145748_c_() {
        String name = this.func_70005_c_();
        return this.func_145818_k_() ? new TextComponentString(name) : new TextComponentTranslation(name, new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public IItemHandlerModifiable getHandler() {
        if (this.handler == null) {
            this.handler = new InvWrapper((IInventory)this);
        }
        return this.handler;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventoryContents) {
            if (stack == null) continue;
            return false;
        }
        return true;
    }
}

