/*
 * Decompiled with CFR 0.152.
 */
package openmods.item;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openmods.item.IMetaItem;

public class MetaGeneric
implements IMetaItem {
    private final String mod;
    private final String name;
    private Object[] recipes;
    private boolean visibleInCreative = true;

    public MetaGeneric(String mod, String name, Object ... recipes) {
        this.mod = mod;
        this.name = name;
        this.recipes = recipes;
    }

    public MetaGeneric hideFromCreative() {
        this.visibleInCreative = false;
        return this;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return String.format("%s.%s", this.mod, this.name);
    }

    @Override
    public boolean hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase player) {
        return false;
    }

    @Override
    public EnumActionResult onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    @Override
    public void addRecipe() {
        if (this.recipes == null) {
            return;
        }
        List craftingRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (Object tmp : this.recipes) {
            if (tmp instanceof SmeltingRecipe) {
                SmeltingRecipe recipe = (SmeltingRecipe)tmp;
                FurnaceRecipes.func_77602_a().func_151394_a(recipe.input, recipe.result, recipe.experience);
                continue;
            }
            if (tmp instanceof IRecipe) {
                craftingRecipes.add((IRecipe)tmp);
                continue;
            }
            throw new IllegalArgumentException("Invalid recipe object: " + tmp);
        }
    }

    @Override
    public void addToCreativeList(Item item, int meta, List<ItemStack> result) {
        if (this.visibleInCreative) {
            result.add(new ItemStack(item, 1, meta));
        }
    }

    @Override
    public boolean hasEffect() {
        return false;
    }

    @Override
    public ResourceLocation getLocation() {
        return new ResourceLocation(this.mod, this.name);
    }

    public static class SmeltingRecipe {
        public final ItemStack input;
        public final ItemStack result;
        public final float experience;

        private SmeltingRecipe(ItemStack input, ItemStack result, float experience) {
            this.input = input;
            this.result = result.func_77946_l();
            this.experience = experience;
        }
    }
}

