/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import openmods.utils.bitmap.IReadableBitMap;

public abstract class SidedFluidCapabilityWrapper {
    private final IFluidHandler tank;
    private final Map<EnumFacing, IFluidHandler> handlers = Maps.newEnumMap(EnumFacing.class);
    private static final IFluidTankProperties[] EMPTY = new IFluidTankProperties[0];

    private SidedFluidCapabilityWrapper(IFluidHandler tank) {
        this.tank = tank;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.handlers.put(side, new Handler(side));
        }
    }

    protected abstract boolean canFill(EnumFacing var1);

    protected abstract boolean canDrain(EnumFacing var1);

    protected boolean canInteract(EnumFacing side) {
        return this.canFill(side) || this.canDrain(side);
    }

    public boolean hasHandler(EnumFacing side) {
        return this.canInteract(side);
    }

    public IFluidHandler getHandler(EnumFacing side) {
        return this.handlers.get(side);
    }

    public static SidedFluidCapabilityWrapper wrap(IFluidHandler tank, final IReadableBitMap<EnumFacing> flags, boolean canDrain, boolean canFill) {
        if (canDrain && canFill) {
            return new SidedFluidCapabilityWrapper(tank){

                @Override
                protected boolean canFill(EnumFacing side) {
                    return flags.get(side);
                }

                @Override
                protected boolean canDrain(EnumFacing side) {
                    return flags.get(side);
                }
            };
        }
        if (canDrain) {
            return new SidedFluidCapabilityWrapper(tank){

                @Override
                protected boolean canFill(EnumFacing side) {
                    return false;
                }

                @Override
                protected boolean canDrain(EnumFacing side) {
                    return flags.get(side);
                }
            };
        }
        if (canFill) {
            return new SidedFluidCapabilityWrapper(tank){

                @Override
                protected boolean canFill(EnumFacing side) {
                    return flags.get(side);
                }

                @Override
                protected boolean canDrain(EnumFacing side) {
                    return false;
                }
            };
        }
        return new SidedFluidCapabilityWrapper(tank){

            @Override
            protected boolean canFill(EnumFacing side) {
                return false;
            }

            @Override
            protected boolean canDrain(EnumFacing side) {
                return false;
            }
        };
    }

    private class Handler
    implements IFluidHandler {
        private final EnumFacing side;

        public Handler(EnumFacing side) {
            this.side = side;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (!SidedFluidCapabilityWrapper.this.canInteract(this.side)) {
                return EMPTY;
            }
            return SidedFluidCapabilityWrapper.this.tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!SidedFluidCapabilityWrapper.this.canFill(this.side)) {
                return 0;
            }
            return SidedFluidCapabilityWrapper.this.tank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!SidedFluidCapabilityWrapper.this.canDrain(this.side)) {
                return null;
            }
            return SidedFluidCapabilityWrapper.this.tank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!SidedFluidCapabilityWrapper.this.canDrain(this.side)) {
                return null;
            }
            return SidedFluidCapabilityWrapper.this.tank.drain(maxDrain, doDrain);
        }
    }
}

