/*
 * Decompiled with CFR 0.152.
 */
package openmods.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class ModelTextureMap {
    private final Map<String, ResourceLocation> textures;

    public ModelTextureMap() {
        this((Map<String, ResourceLocation>)ImmutableMap.of());
    }

    private ModelTextureMap(Map<String, ResourceLocation> textures) {
        this.textures = ImmutableMap.copyOf(textures);
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures.values();
    }

    public Optional<ModelTextureMap> update(Map<String, String> updates) {
        if (updates.isEmpty()) {
            return Optional.absent();
        }
        HashMap newTextures = Maps.newHashMap(this.textures);
        for (Map.Entry<String, String> e : updates.entrySet()) {
            String location = e.getValue();
            if (Strings.isNullOrEmpty((String)location)) {
                newTextures.remove(e.getKey());
                continue;
            }
            newTextures.put(e.getKey(), new ResourceLocation(location));
        }
        return Optional.of((Object)new ModelTextureMap(newTextures));
    }

    public Iterable<TextureAtlasSprite> bake(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        HashSet texturesToGet = Sets.newHashSet(this.textures.values());
        return Iterables.transform((Iterable)texturesToGet, bakedTextureGetter);
    }

    public Map<String, TextureAtlasSprite> bakeWithKeys(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return Maps.transformValues(this.textures, bakedTextureGetter);
    }
}

