/*
 * Decompiled with CFR 0.152.
 */
package openmods.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class ModelUpdater {
    public static final ValueConverter<ResourceLocation> RESOURCE_LOCATION = new ValueConverter<ResourceLocation>(){

        @Override
        public ResourceLocation convert(String name, JsonElement element) {
            String value = JsonUtils.func_151206_a((JsonElement)element, (String)name);
            return new ResourceLocation(value);
        }
    };
    public static final ValueConverter<ModelResourceLocation> MODEL_RESOURCE_LOCATION = new ValueConverter<ModelResourceLocation>(){

        @Override
        public ModelResourceLocation convert(String name, JsonElement element) {
            String value = JsonUtils.func_151206_a((JsonElement)element, (String)name);
            return new ModelResourceLocation(value);
        }
    };
    public static final ValueConverter<ResourceLocation> MODEL_LOCATION = new ValueConverter<ResourceLocation>(){

        @Override
        public ResourceLocation convert(String name, JsonElement element) {
            String value = JsonUtils.func_151206_a((JsonElement)element, (String)name);
            return value.contains("#") ? new ModelResourceLocation(value) : new ResourceLocation(value);
        }
    };
    public static final ValueConverter<String> TO_STRING = new ValueConverter<String>(){

        @Override
        public String convert(String name, JsonElement element) {
            return JsonUtils.func_151206_a((JsonElement)element, (String)name);
        }
    };
    public static final ValueConverter<Integer> TO_INT = new ValueConverter<Integer>(){

        @Override
        public Integer convert(String name, JsonElement element) {
            return JsonUtils.func_151215_f((JsonElement)element, (String)name);
        }
    };
    public static final ValueConverter<Long> TO_LONG = new ValueConverter<Long>(){

        @Override
        public Long convert(String name, JsonElement element) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                return element.getAsLong();
            }
            throw new JsonSyntaxException("Expected " + name + " to be a Int, was " + JsonUtils.func_151222_d((JsonElement)element));
        }
    };
    private final Map<String, String> values;
    private final JsonParser parser = new JsonParser();
    private boolean changed;

    public static <T extends Enum<T>> ValueConverter<T> enumConverter(Class<T> enumCls) {
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        for (Enum c : (Enum[])enumCls.getEnumConstants()) {
            valuesBuilder.put((Object)c.name().toLowerCase(), (Object)c);
        }
        final ImmutableMap values = valuesBuilder.build();
        return new ValueConverter<T>(){

            @Override
            public T convert(String name, JsonElement element) {
                String enumName = JsonUtils.func_151206_a((JsonElement)element, (String)name);
                return (Enum)values.get((Object)enumName.toLowerCase());
            }
        };
    }

    public ModelUpdater(Map<String, String> values) {
        this.values = values;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void markChanged() {
        this.changed = true;
    }

    public <T> T get(String key, ValueConverter<T> converter, T current) {
        JsonElement element;
        T result;
        String value = this.values.get(key);
        if (value != null && !(result = converter.convert(key, element = this.parser.parse(value))).equals(current)) {
            this.changed = true;
            return result;
        }
        return current;
    }

    public <T> Optional<T> get(String key, final ValueConverter<T> converter, Optional<T> current) {
        return this.get(key, (ValueConverter<T>)new ValueConverter<Optional<T>>(){

            @Override
            public Optional<T> convert(String name, JsonElement element) {
                return Optional.of(converter.convert(name, element));
            }
        }, (T)current);
    }

    public <T> Set<T> get(String key, ValueConverter<T> converter, Set<T> current) {
        String value = this.values.get(key);
        if (value != null) {
            JsonElement parsedValue = this.parser.parse(value);
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            if (parsedValue.isJsonArray()) {
                for (JsonElement e : parsedValue.getAsJsonArray()) {
                    resultBuilder.add(converter.convert(key, e));
                }
            } else {
                resultBuilder.add(converter.convert(key, parsedValue));
            }
            ImmutableSet result = resultBuilder.build();
            if (!result.equals(current)) {
                this.changed = true;
                return result;
            }
        }
        return current;
    }

    public static interface ValueConverter<T> {
        public T convert(String var1, JsonElement var2);
    }
}

