/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import openmods.model.BakedModelAdapter;
import openmods.model.eval.EvalModelState;
import openmods.model.eval.IEvaluator;

public class BakedEvalModel
extends BakedModelAdapter {
    private IModel model;
    private IModelState originalState;
    private VertexFormat format;
    private Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private IEvaluator evaluator;
    private final LoadingCache<Map<String, Float>, IBakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Map<String, Float>, IBakedModel>(){

        public IBakedModel load(Map<String, Float> key) throws Exception {
            IModelState clipTransform = BakedEvalModel.this.evaluator.evaluate(key);
            return BakedEvalModel.this.bakeModelWithTransform(clipTransform);
        }
    });

    public BakedEvalModel(IModel model, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, IEvaluator evaluator) {
        super(model.bake(state, format, bakedTextureGetter), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
        this.model = model;
        this.originalState = state;
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.evaluator = evaluator;
    }

    private IBakedModel bakeModelWithTransform(IModelState transform) {
        ModelStateComposition compositeState = new ModelStateComposition(this.originalState, transform);
        return this.model.bake((IModelState)compositeState, this.format, this.bakedTextureGetter);
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IExtendedBlockState extState;
        EvalModelState args;
        if (state instanceof IExtendedBlockState && (args = (EvalModelState)(extState = (IExtendedBlockState)state).getValue(EvalModelState.PROPERTY)) != null) {
            return ((IBakedModel)this.cache.getUnchecked(args.getArgs())).func_188616_a(state, side, rand);
        }
        return super.func_188616_a(state, side, rand);
    }
}

