/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.ModelUpdater;
import openmods.model.eval.BakedEvalModel;
import openmods.model.eval.EvaluatorFactory;
import openmods.model.eval.IEvaluator;

public class EvalModel
implements IModelCustomData {
    public static final IModel EMPTY = new EvalModel((Optional<ResourceLocation>)Optional.absent(), new EvaluatorFactory());
    private final Optional<ResourceLocation> baseModel;
    private final EvaluatorFactory evaluatorFactory;

    private EvalModel(Optional<ResourceLocation> baseModel, EvaluatorFactory evaluator) {
        this.baseModel = baseModel;
        this.evaluatorFactory = evaluator;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.baseModel.asSet();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel model = this.baseModel.isPresent() ? ModelLoaderRegistry.getModelOrLogError((ResourceLocation)((ResourceLocation)this.baseModel.get()), (String)("Couldn't load eval model dependency: " + this.baseModel.get())) : ModelLoaderRegistry.getMissingModel();
        IEvaluator evaluator = this.evaluatorFactory.bind(model);
        return new BakedEvalModel(model, state, format, bakedTextureGetter, evaluator);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> baseModel = updater.get("base", ModelUpdater.MODEL_LOCATION, this.baseModel);
        EvaluatorFactory evaluatorFactory = updater.get("transforms", new ModelUpdater.ValueConverter<EvaluatorFactory>(){

            @Override
            public EvaluatorFactory convert(String name, JsonElement element) {
                EvaluatorFactory result = new EvaluatorFactory();
                if (element.isJsonArray()) {
                    for (JsonElement e : element.getAsJsonArray()) {
                        this.appendStatement(result, e);
                    }
                } else {
                    this.appendStatement(result, element);
                }
                return result;
            }

            private void appendStatement(EvaluatorFactory factory, JsonElement statement) {
                factory.appendStatement(statement.getAsString());
            }
        }, this.evaluatorFactory);
        return updater.hasChanged() ? new EvalModel(baseModel, evaluatorFactory) : this;
    }
}

