/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.animation.IAnimatedModel;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import openmods.model.eval.IEvaluator;
import org.apache.commons.lang3.tuple.Pair;

public class EvaluatorFactory {
    private static final IEvaluator EMPTY = new IEvaluator(){

        @Override
        public IModelState evaluate(Map<String, Float> args) {
            return TRSRTransformation.identity();
        }
    };
    private static final Pattern SIMPLE_EXPR = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]+)\\(([a-zA-Z_][a-zA-Z0-9_]+)\\)");
    private final List<Pair<String, String>> clipArgs = Lists.newArrayList();

    public void appendStatement(String statement) {
        Matcher matcher = SIMPLE_EXPR.matcher(statement);
        Preconditions.checkState((boolean)matcher.matches(), (Object)"Invalid statement, expected 'clip(arg)'");
        String clip = matcher.group(1);
        String arg = matcher.group(2);
        this.clipArgs.add((Pair<String, String>)Pair.of((Object)clip, (Object)arg));
    }

    public IEvaluator bind(IModel model) {
        if (!(model instanceof IAnimatedModel)) {
            return EMPTY;
        }
        IAnimatedModel animatedModel = (IAnimatedModel)model;
        ArrayList args = Lists.newArrayList();
        for (Pair<String, String> clipArg : this.clipArgs) {
            String clipName = (String)clipArg.getKey();
            String arg = (String)clipArg.getValue();
            Optional clip = animatedModel.getClip(clipName);
            Preconditions.checkState((boolean)clip.isPresent(), (String)"Can't find clip '%s'", (Object[])new Object[]{clipName});
            args.add(Pair.of((Object)clip.get(), (Object)arg));
        }
        return new ClipEvaluator(args);
    }

    private static class ClipEvaluator
    implements IEvaluator {
        private final List<Pair<IClip, String>> clips;

        public ClipEvaluator(List<Pair<IClip, String>> clips) {
            this.clips = ImmutableList.copyOf(clips);
        }

        @Override
        public IModelState evaluate(final Map<String, Float> args) {
            return new IModelState(){

                public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
                    if (!part.isPresent()) {
                        return Optional.absent();
                    }
                    IModelPart maybeJoint = (IModelPart)part.get();
                    if (!(maybeJoint instanceof IJoint)) {
                        return Optional.absent();
                    }
                    IJoint joint = (IJoint)part.get();
                    TRSRTransformation result = TRSRTransformation.identity();
                    for (Pair clip : ClipEvaluator.this.clips) {
                        Float maybeArg = (Float)args.get(clip.getRight());
                        float arg = maybeArg != null ? maybeArg.floatValue() : 0.0f;
                        TRSRTransformation clipTransform = ((IClip)clip.getLeft()).apply(joint).apply(arg);
                        result = result.compose(clipTransform);
                    }
                    return Optional.of((Object)result);
                }
            };
        }
    }
}

