/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.itemstate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.ModelUpdater;
import openmods.model.itemstate.IStateItem;
import openmods.model.itemstate.ItemStateOverrideList;
import openmods.state.State;
import openmods.state.StateContainer;

public class ItemStateModel
implements IModelCustomData {
    private final Optional<ResourceLocation> itemLocation;
    private final Optional<ResourceLocation> defaultModel;
    private final Map<State, ResourceLocation> stateModels;
    public static final ItemStateModel EMPTY = new ItemStateModel((Optional<ResourceLocation>)Optional.absent(), (Optional<ResourceLocation>)Optional.absent());

    private ItemStateModel(Optional<ResourceLocation> itemLocation, Optional<ResourceLocation> defaultModel) {
        this.itemLocation = itemLocation;
        this.defaultModel = defaultModel;
        this.stateModels = this.createModelLocations();
    }

    private Map<State, ResourceLocation> createModelLocations() {
        if (!this.itemLocation.isPresent()) {
            return ImmutableMap.of();
        }
        Item item = (Item)Item.field_150901_e.func_82594_a(this.itemLocation.get());
        if (!(item instanceof IStateItem)) {
            return ImmutableMap.of();
        }
        StateContainer stateContainer = ((IStateItem)item).getStateContainer();
        ImmutableMap.Builder result = ImmutableMap.builder();
        ResourceLocation base = item.getRegistryName();
        for (State state : stateContainer.getAllStates()) {
            result.put((Object)state, (Object)new ModelResourceLocation(base, state.getVariant()));
        }
        return result.build();
    }

    public Collection<ResourceLocation> getDependencies() {
        return Sets.union((Set)ImmutableSet.copyOf(this.stateModels.values()), (Set)this.defaultModel.asSet());
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, final VertexFormat format, final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel defaultModel;
        if (this.defaultModel.isPresent()) {
            defaultModel = ItemStateModel.getModel((ResourceLocation)this.defaultModel.get());
        } else if (!this.stateModels.isEmpty()) {
            ResourceLocation first = this.stateModels.values().iterator().next();
            defaultModel = ItemStateModel.getModel(first);
        } else {
            defaultModel = ModelLoaderRegistry.getMissingModel();
        }
        IBakedModel bakedDefaultModel = defaultModel.bake(defaultModel.getDefaultState(), format, bakedTextureGetter);
        Map bakedStateModels = Maps.transformValues(this.stateModels, (Function)new Function<ResourceLocation, IBakedModel>(){

            public IBakedModel apply(@Nullable ResourceLocation input) {
                IModel model = ItemStateModel.getModel(input);
                return model.bake(model.getDefaultState(), format, bakedTextureGetter);
            }
        });
        return new ItemStateOverrideList(bakedStateModels).wrapModel(bakedDefaultModel);
    }

    private static IModel getModel(ResourceLocation model) {
        return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)model, (String)("Couldn't load model dependency: " + model));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> itemLocation = updater.get("item", ModelUpdater.RESOURCE_LOCATION, this.itemLocation);
        Optional<ResourceLocation> defaultModel = updater.get("default", ModelUpdater.MODEL_LOCATION, this.defaultModel);
        return updater.hasChanged() ? new ItemStateModel(itemLocation, defaultModel) : this;
    }
}

