/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.textureditem;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.BakedModelAdapter;
import openmods.model.ModelUpdater;
import openmods.model.textureditem.TexturedItemOverrides;

public class TexturedItemModel
implements IModelCustomData {
    public static final TexturedItemModel INSTANCE = new TexturedItemModel();
    private final Optional<ResourceLocation> untexturedModel;
    private final Optional<ResourceLocation> texturedModel;
    private final Set<String> textures;

    private TexturedItemModel() {
        this.untexturedModel = Optional.absent();
        this.texturedModel = Optional.absent();
        this.textures = ImmutableSet.of();
    }

    private TexturedItemModel(Optional<ResourceLocation> empty, Optional<ResourceLocation> fluid, Set<String> textures) {
        this.untexturedModel = empty;
        this.texturedModel = fluid;
        this.textures = ImmutableSet.copyOf(textures);
    }

    public Collection<ResourceLocation> getDependencies() {
        return Sets.union((Set)this.untexturedModel.asSet(), (Set)this.texturedModel.asSet());
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel untexturedModel = TexturedItemModel.getModel(this.untexturedModel);
        IBakedModel untexturedBakedModel = untexturedModel.bake((IModelState)new ModelStateComposition(state, untexturedModel.getDefaultState()), format, bakedTextureGetter);
        IModel texturedModel = TexturedItemModel.getModel(this.texturedModel);
        IBakedModel texturedBakedModel = texturedModel.bake((IModelState)new ModelStateComposition(state, texturedModel.getDefaultState()), format, bakedTextureGetter);
        TexturedItemOverrides overrides = new TexturedItemOverrides(untexturedBakedModel, texturedModel, (List<ItemOverride>)texturedBakedModel.func_188617_f().getOverrides(), this.textures, state, format, bakedTextureGetter);
        return new BakedModel(untexturedBakedModel, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state), overrides);
    }

    private static IModel getModel(Optional<ResourceLocation> model) {
        if (model.isPresent()) {
            ResourceLocation location = (ResourceLocation)model.get();
            return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Couldn't load base-model dependency: " + location));
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> untexturedModel = updater.get("untexturedModel", ModelUpdater.MODEL_LOCATION, this.untexturedModel);
        Optional<ResourceLocation> filled = updater.get("texturedModel", ModelUpdater.MODEL_LOCATION, this.texturedModel);
        Set<String> textures = updater.get("textures", ModelUpdater.TO_STRING, this.textures);
        return updater.hasChanged() ? new TexturedItemModel(untexturedModel, filled, textures) : this;
    }

    private static class BakedModel
    extends BakedModelAdapter {
        private final ItemOverrideList overrideList;

        public BakedModel(IBakedModel base, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms, ItemOverrideList itemOverrideList) {
            super(base, cameraTransforms);
            this.overrideList = itemOverrideList;
        }

        @Override
        public ItemOverrideList func_188617_f() {
            return this.overrideList;
        }
    }
}

