/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.textureditem;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import openmods.model.textureditem.IItemTexture;
import openmods.model.textureditem.ItemTextureCapability;
import org.apache.commons.lang3.tuple.Pair;

public class TexturedItemOverrides
extends ItemOverrideList {
    private final IBakedModel untexturedModel;
    private final IModel texturedModel;
    private final Set<String> texturesToReplace;
    private final IModelState state;
    private final VertexFormat format;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final LoadingCache<Pair<ResourceLocation, Optional<ResourceLocation>>, IBakedModel> textureOverrides = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<ResourceLocation, Optional<ResourceLocation>>, IBakedModel>(){

        public IBakedModel load(Pair<ResourceLocation, Optional<ResourceLocation>> key) throws Exception {
            IModel overrideModel = TexturedItemOverrides.this.getOverrideModel((Optional<ResourceLocation>)((Optional)key.getRight()));
            IModel retexturedModel = TexturedItemOverrides.this.retextureModel(overrideModel, (ResourceLocation)key.getKey());
            return retexturedModel.bake(TexturedItemOverrides.this.state, TexturedItemOverrides.this.format, TexturedItemOverrides.this.bakedTextureGetter);
        }
    });

    public TexturedItemOverrides(IBakedModel untexturedModel, IModel texturedModel, List<ItemOverride> texturedModelOverrides, Set<String> texturesToReplace, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(texturedModelOverrides);
        this.untexturedModel = untexturedModel;
        this.texturedModel = texturedModel;
        this.texturesToReplace = ImmutableSet.copyOf(texturesToReplace);
        this.state = state;
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        Optional<ResourceLocation> texture = TexturedItemOverrides.getTextureFromStack(stack);
        return texture.isPresent() ? this.rebakeModel((ResourceLocation)texture.get(), stack, world, entity) : this.untexturedModel;
    }

    private IBakedModel rebakeModel(ResourceLocation texture, ItemStack stack, World world, EntityLivingBase entity) {
        Optional overrideLocation = Optional.fromNullable((Object)this.func_188021_a(stack, world, entity));
        return (IBakedModel)this.textureOverrides.getUnchecked((Object)Pair.of((Object)texture, (Object)overrideLocation));
    }

    private IModel getOverrideModel(Optional<ResourceLocation> overrideLocation) {
        if (overrideLocation.isPresent()) {
            ResourceLocation location = (ResourceLocation)overrideLocation.get();
            return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Couldn't load model: " + location));
        }
        return this.texturedModel;
    }

    private IModel retextureModel(IModel overrideModel, ResourceLocation texture) {
        if (overrideModel instanceof IRetexturableModel) {
            ImmutableMap.Builder textures = ImmutableMap.builder();
            for (String t : this.texturesToReplace) {
                textures.put((Object)t, (Object)texture.toString());
            }
            return ((IRetexturableModel)overrideModel).retexture(textures.build());
        }
        return overrideModel;
    }

    private static Optional<ResourceLocation> getTextureFromStack(ItemStack stack) {
        if (stack.hasCapability(ItemTextureCapability.CAPABILITY, null)) {
            IItemTexture fluidRender = (IItemTexture)stack.getCapability(ItemTextureCapability.CAPABILITY, null);
            return fluidRender.getTexture();
        }
        return Optional.absent();
    }
}

