/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.variant;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.parsing.ast.INodeFactory;
import info.openmods.calc.parsing.ast.IOperator;
import info.openmods.calc.parsing.ast.InfixParser;
import info.openmods.calc.parsing.ast.OperatorArity;
import info.openmods.calc.parsing.ast.SimpleParserState;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenIterator;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.parsing.token.Tokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Evaluator {
    private static final String MODIFIER_ASSIGN = ":=";
    private static final int PRIORITY_DOT = 5;
    private static final String OPERATOR_DOT = ".";
    private static final int PRIORITY_NOT = 4;
    private static final String OPERATOR_NOT = "!";
    private static final int PRIORITY_AND = 3;
    private static final String OPERATOR_AND = "&";
    private static final int PRIORITY_OR = 2;
    private static final String OPERATOR_OR = "|";
    private static final int PRIORITY_COMPARE = 1;
    private static final String OPERATOR_XOR = "^";
    private static final String OPERATOR_EQ = "=";
    private static final Tokenizer tokenizer = new Tokenizer();
    private static final OperatorDictionary<Operator> operators;
    private static final IExpr TRUE;
    private static final IExpr FALSE;
    private static final INodeFactory<IExpr, Operator> nodeFactory;
    private static final InfixParser<IExpr, Operator> parser;
    private final SimpleParserState<IExpr> parserState = new SimpleParserState<IExpr>(parser){

        protected IExpr createModifierNode(String modifier, IExpr child) {
            throw new UnsupportedOperationException();
        }

        protected IExpr createSymbolNode(String symbol, List<IExpr> children) {
            Macro macro = (Macro)Evaluator.this.macros.get(symbol);
            Preconditions.checkState((macro != null ? 1 : 0) != 0, (String)"Can't find macro %s", (Object[])new Object[]{symbol});
            return macro.rebind(children);
        }
    };
    private final List<IStatement> program = Lists.newArrayList();
    private Map<String, Macro> macros = Maps.newHashMap();

    private static String expectToken(Iterator<Token> tokens, TokenType type) {
        Preconditions.checkState((boolean)tokens.hasNext(), (String)"Expected %s, got end of statement", (Object[])new Object[]{type});
        Token result = tokens.next();
        Preconditions.checkState((result.type == type ? 1 : 0) != 0, (String)"Expect %s, got %s", (Object[])new Object[]{type, result});
        return result.value;
    }

    private static void expectToken(Iterator<Token> tokens, TokenType type, String value) {
        Preconditions.checkState((boolean)tokens.hasNext(), (String)"Expected %s, got end of statement", (Object[])new Object[]{type});
        Token result = tokens.next();
        Preconditions.checkState((result.type == type && result.value.equals(value) ? 1 : 0) != 0, (String)"Expect %s:%s, got %s", (Object[])new Object[]{type, value, result});
    }

    private static Token expectTokens(Iterator<Token> tokens, TokenType ... types) {
        Preconditions.checkState((boolean)tokens.hasNext(), (String)"Expected %s, got end of statement", (Object[])new Object[]{Arrays.toString(types)});
        Token result = tokens.next();
        Preconditions.checkState((boolean)ImmutableSet.of((Object)types).contains((Object)types), (String)"Expect %s, got %s", (Object[])new Object[]{Arrays.toString(types), result});
        return result;
    }

    public static IExpr constant(boolean value) {
        return value ? TRUE : FALSE;
    }

    private IExpr parseExpression(PeekingIterator<Token> tokens) {
        return ((IExpr)this.parserState.parse(tokens)).fold();
    }

    private static List<String> parseMacroArgList(PeekingIterator<Token> tokens) {
        Token token;
        Token firstToken = Evaluator.expectTokens(tokens, new TokenType[]{TokenType.SYMBOL, TokenType.RIGHT_BRACKET});
        ArrayList args = Lists.newArrayList();
        if (firstToken.type == TokenType.RIGHT_BRACKET) {
            Preconditions.checkState((boolean)firstToken.value.equals(")"), (String)"Unexpected bracket: '%s'", (Object[])new Object[]{firstToken.value});
            return args;
        }
        args.add(firstToken.value);
        while (true) {
            token = Evaluator.expectTokens(tokens, new TokenType[]{TokenType.SEPARATOR, TokenType.RIGHT_BRACKET});
            if (token.type == TokenType.RIGHT_BRACKET) break;
            String arg = Evaluator.expectToken(tokens, TokenType.SYMBOL);
            args.add(arg);
        }
        Preconditions.checkState((boolean)token.value.equals(")"), (String)"Unexpected bracket: '%s'", (Object[])new Object[]{token.value});
        return args;
    }

    private Macro parseMacro(PeekingIterator<Token> tokens) {
        List<String> args = Evaluator.parseMacroArgList(tokens);
        Evaluator.expectToken(tokens, TokenType.MODIFIER, MODIFIER_ASSIGN);
        IExpr body = this.parseExpression(tokens);
        return new Macro(args, body);
    }

    public void addStatement(String statement) {
        block5: {
            try {
                TokenIterator tokens = tokenizer.tokenize(statement);
                String definedSymbol = Evaluator.expectToken((Iterator<Token>)tokens, TokenType.SYMBOL);
                Token token = Evaluator.expectTokens((Iterator<Token>)tokens, TokenType.LEFT_BRACKET, TokenType.MODIFIER, TokenType.OPERATOR);
                if (token.type == TokenType.LEFT_BRACKET) {
                    Preconditions.checkState((boolean)token.value.equals("("), (String)"Invalid bracket: '%s'", (Object[])new Object[]{token.value});
                    this.macros.put(definedSymbol, this.parseMacro((PeekingIterator<Token>)tokens));
                    break block5;
                }
                if (token.type == TokenType.OPERATOR) {
                    Preconditions.checkState((boolean)token.value.equals(OPERATOR_DOT), (String)"Invalid token: ", (Object[])new Object[]{token});
                    String value = Evaluator.expectToken((Iterator<Token>)tokens, TokenType.SYMBOL);
                    Evaluator.expectToken((Iterator<Token>)tokens, TokenType.MODIFIER, MODIFIER_ASSIGN);
                    IExpr expr = this.parseExpression((PeekingIterator<Token>)tokens);
                    this.program.add(new SetKeyValueVar(expr, definedSymbol, value));
                    break block5;
                }
                if (token.type == TokenType.MODIFIER) {
                    Preconditions.checkState((boolean)token.value.equals(MODIFIER_ASSIGN), (String)"Invalid token: ", (Object[])new Object[]{token});
                    IExpr expr = this.parseExpression((PeekingIterator<Token>)tokens);
                    this.program.add(new SetKeyOnlyVar(expr, definedSymbol));
                    break block5;
                }
                throw new IllegalArgumentException("Unexpected token: " + token);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse: " + statement, e);
            }
        }
    }

    public void expandVars(Map<String, String> vars) {
        for (IStatement statement : this.program) {
            statement.execute(vars);
        }
    }

    static {
        tokenizer.addModifier(MODIFIER_ASSIGN);
        tokenizer.addOperator(OPERATOR_DOT);
        tokenizer.addOperator(OPERATOR_OR);
        tokenizer.addOperator(OPERATOR_AND);
        tokenizer.addOperator(OPERATOR_XOR);
        tokenizer.addOperator(OPERATOR_EQ);
        tokenizer.addOperator(OPERATOR_NOT);
        operators = new OperatorDictionary();
        TRUE = new Constant(){

            @Override
            protected boolean value() {
                return true;
            }
        };
        FALSE = new Constant(){

            @Override
            protected boolean value() {
                return false;
            }
        };
        operators.registerOperator((IOperator)new UnaryOperator(OPERATOR_NOT, 4){

            @Override
            protected IExpr createNode(IExpr value) {
                return new OperatorNot(value);
            }
        });
        operators.registerOperator((IOperator)new BinaryOperator(OPERATOR_AND, 3){

            @Override
            protected IExpr createNode(IExpr left, IExpr right) {
                return new AndOperator(left, right);
            }
        });
        operators.registerOperator((IOperator)new BinaryOperator(OPERATOR_OR, 2){

            @Override
            protected IExpr createNode(IExpr left, IExpr right) {
                return new OrOperator(left, right);
            }
        });
        operators.registerOperator((IOperator)new BinaryOperator(OPERATOR_EQ, 1){

            @Override
            protected IExpr createNode(IExpr left, IExpr right) {
                return new EqOperator(left, right);
            }
        });
        operators.registerOperator((IOperator)new BinaryOperator(OPERATOR_XOR, 1){

            @Override
            protected IExpr createNode(IExpr left, IExpr right) {
                return new XorOperator(left, right);
            }
        });
        operators.registerOperator((IOperator)new BinaryOperator(OPERATOR_DOT, 5){

            @Override
            protected IExpr createNode(IExpr left, IExpr right) {
                Preconditions.checkState((boolean)(left instanceof KeyGet), (Object)"Expected symbol on left side of dot");
                Preconditions.checkState((boolean)(right instanceof KeyGet), (Object)"Expected symbol on right side of dot");
                String key = ((KeyGet)left).key;
                String value = ((KeyGet)right).key;
                return new KeyValueGet(key, value);
            }
        });
        nodeFactory = new INodeFactory<IExpr, Operator>(){

            public IExpr createBracketNode(String openingBracket, String closingBracket, List<IExpr> children) {
                Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (Object)"Invalid number of elements in bracket");
                return new SeparatorExpr(children.get(0));
            }

            public IExpr createOpNode(Operator op, List<IExpr> children) {
                return op.createNode(children);
            }

            public IExpr createSymbolGetNode(String id) {
                return new KeyGet(id);
            }

            public IExpr createValueNode(Token token) {
                if (token.type.isNumber()) {
                    if (token.value.equals("1")) {
                        return TRUE;
                    }
                    if (token.value.equals("0")) {
                        return FALSE;
                    }
                }
                throw new UnsupportedOperationException();
            }
        };
        parser = new InfixParser(operators, nodeFactory);
    }

    private static class SetKeyValueVar
    extends SetVar {
        private final String key;
        private final String value;

        public SetKeyValueVar(IExpr expr, String key, String value) {
            super(expr);
            this.key = key;
            this.value = value;
        }

        @Override
        protected void setValue(boolean result, Map<String, String> vars) {
            if (result) {
                vars.put(this.key, this.value);
            } else {
                String value = vars.get(this.key);
                if (Objects.equal((Object)this.value, (Object)value)) {
                    vars.remove(this.key);
                }
            }
        }
    }

    private static class SetKeyOnlyVar
    extends SetVar {
        private final String key;

        public SetKeyOnlyVar(IExpr expr, String key) {
            super(expr);
            this.key = key;
        }

        @Override
        protected void setValue(boolean result, Map<String, String> vars) {
            if (result) {
                vars.put(this.key, "<default>");
            } else {
                vars.remove(this.key);
            }
        }
    }

    private static abstract class SetVar
    implements IStatement {
        private final IExpr expr;

        public SetVar(IExpr expr) {
            this.expr = expr;
        }

        @Override
        public void execute(Map<String, String> vars) {
            boolean result = this.expr.evaluate(vars);
            this.setValue(result, vars);
        }

        protected abstract void setValue(boolean var1, Map<String, String> var2);
    }

    private static interface IStatement {
        public void execute(Map<String, String> var1);
    }

    private static class Macro {
        private final List<String> args;
        private final IExpr body;

        public Macro(List<String> args, IExpr body) {
            this.args = args;
            this.body = body;
        }

        public IExpr rebind(List<IExpr> children) {
            int expectedArgCount;
            int actualArgCount = children.size();
            Preconditions.checkState((actualArgCount == (expectedArgCount = this.args.size()) ? 1 : 0) != 0, (String)"Invalid numer of arguments: expected %s, got %s", (Object[])new Object[]{expectedArgCount, actualArgCount});
            HashMap env = Maps.newHashMap();
            for (int i = 0; i < expectedArgCount; ++i) {
                String arg = this.args.get(i);
                IExpr value = children.get(i);
                env.put(arg, value);
            }
            return this.body.rebind(env);
        }
    }

    private static class SeparatorExpr
    implements IExpr {
        private final IExpr expr;

        public SeparatorExpr(IExpr expr) {
            this.expr = expr;
        }

        @Override
        public boolean evaluate(Map<String, String> vars) {
            throw new AssertionError();
        }

        @Override
        public IExpr rebind(Map<String, IExpr> vars) {
            return this.expr.rebind(vars);
        }

        @Override
        public Optional<Boolean> getConstantValue() {
            return Optional.absent();
        }

        @Override
        public IExpr fold() {
            return this.expr.fold();
        }

        @Override
        public boolean equals(IExpr other) {
            if (this == other) {
                return true;
            }
            return other instanceof SeparatorExpr && ((SeparatorExpr)other).expr.equals(this.expr);
        }
    }

    private static class KeyValueGet
    implements IVar {
        private final String key;
        private final String value;

        public KeyValueGet(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean evaluate(Map<String, String> vars) {
            String value = vars.get(this.key);
            return Objects.equal((Object)value, (Object)this.value);
        }

        @Override
        public IExpr rebind(Map<String, IExpr> vars) {
            IExpr var = vars.get(this.key);
            if (var == null) {
                return this;
            }
            Preconditions.checkState((boolean)(var instanceof KeyGet), (String)"Tried to extract value '%s' from expression expanded from key '%s'", (Object[])new Object[]{this.value, this.key});
            String newKey = ((KeyGet)var).key;
            return new KeyValueGet(newKey, this.value);
        }

        @Override
        public Optional<Boolean> getConstantValue() {
            return Optional.absent();
        }

        @Override
        public IExpr fold() {
            return this;
        }

        @Override
        public boolean equals(IExpr other) {
            if (other == this) {
                return true;
            }
            if (other instanceof KeyValueGet) {
                KeyValueGet o = (KeyValueGet)other;
                return o.key.equals(this.key) && o.value.equals(this.value);
            }
            return false;
        }

        @Override
        public boolean isLessSpecific(IVar other) {
            if (other instanceof KeyGet) {
                return ((KeyGet)other).key.equals(this.key);
            }
            return false;
        }
    }

    private static class KeyGet
    implements IVar {
        private final String key;

        public KeyGet(String key) {
            this.key = key;
        }

        @Override
        public boolean evaluate(Map<String, String> vars) {
            return vars.containsKey(this.key);
        }

        @Override
        public IExpr rebind(Map<String, IExpr> vars) {
            IExpr var = vars.get(this.key);
            return var != null ? var : this;
        }

        @Override
        public Optional<Boolean> getConstantValue() {
            return Optional.absent();
        }

        @Override
        public IExpr fold() {
            return this;
        }

        @Override
        public boolean equals(IExpr other) {
            if (other == this) {
                return true;
            }
            if (other instanceof KeyGet) {
                return ((KeyGet)other).key.equals(this.key);
            }
            return false;
        }

        @Override
        public boolean isLessSpecific(IVar other) {
            return false;
        }
    }

    private static interface IVar
    extends IExpr {
        public boolean isLessSpecific(IVar var1);
    }

    private static interface IExpr {
        public boolean evaluate(Map<String, String> var1);

        public IExpr rebind(Map<String, IExpr> var1);

        public Optional<Boolean> getConstantValue();

        public IExpr fold();

        public boolean equals(IExpr var1);
    }

    private static class XorOperator
    extends BinaryOperatorExpr
    implements NegatableOperator {
        public XorOperator(IExpr left, IExpr right) {
            super(left, right);
        }

        @Override
        protected IExpr create(IExpr left, IExpr right) {
            return new XorOperator(left, right);
        }

        @Override
        protected IExpr fold(boolean value, IExpr arg) {
            return value ? new OperatorNot(arg) : arg;
        }

        @Override
        protected IExpr foldSameExpr(IExpr expr) {
            return FALSE;
        }

        @Override
        protected IExpr foldLessSpecific(IVar lessSpecificVar, IVar moreSpecificVar) {
            return this.create(lessSpecificVar, moreSpecificVar);
        }

        @Override
        protected boolean evaluate(boolean left, boolean right) {
            return left ^ right;
        }

        @Override
        public IExpr negation() {
            return new EqOperator(this.left, this.right);
        }
    }

    private static class EqOperator
    extends BinaryOperatorExpr
    implements NegatableOperator {
        public EqOperator(IExpr left, IExpr right) {
            super(left, right);
        }

        @Override
        protected IExpr create(IExpr left, IExpr right) {
            return new EqOperator(left, right);
        }

        @Override
        protected IExpr fold(boolean arg, IExpr node) {
            return arg ? node : new OperatorNot(node);
        }

        @Override
        protected IExpr foldSameExpr(IExpr expr) {
            return TRUE;
        }

        @Override
        protected IExpr foldLessSpecific(IVar lessSpecificVar, IVar moreSpecificVar) {
            return this.create(lessSpecificVar, moreSpecificVar);
        }

        @Override
        protected boolean evaluate(boolean left, boolean right) {
            return left == right;
        }

        @Override
        public IExpr negation() {
            return new XorOperator(this.left, this.right);
        }
    }

    private static class OrOperator
    extends BinaryOperatorExpr {
        public OrOperator(IExpr left, IExpr right) {
            super(left, right);
        }

        @Override
        protected IExpr create(IExpr left, IExpr right) {
            return new OrOperator(left, right);
        }

        @Override
        protected IExpr fold(boolean arg, IExpr node) {
            return arg ? TRUE : node;
        }

        @Override
        protected IExpr foldSameExpr(IExpr expr) {
            return expr;
        }

        @Override
        protected IExpr foldLessSpecific(IVar lessSpecificVar, IVar moreSpecificVar) {
            return lessSpecificVar;
        }

        @Override
        protected boolean evaluate(boolean left, boolean right) {
            return left || right;
        }
    }

    private static class AndOperator
    extends BinaryOperatorExpr {
        public AndOperator(IExpr left, IExpr right) {
            super(left, right);
        }

        @Override
        protected IExpr create(IExpr left, IExpr right) {
            return new AndOperator(left, right);
        }

        @Override
        protected IExpr fold(boolean arg, IExpr node) {
            return arg ? node : FALSE;
        }

        @Override
        protected IExpr foldSameExpr(IExpr expr) {
            return expr;
        }

        @Override
        protected IExpr foldLessSpecific(IVar lessSpecificVar, IVar moreSpecificVar) {
            return moreSpecificVar;
        }

        @Override
        protected boolean evaluate(boolean left, boolean right) {
            return left && right;
        }
    }

    private static abstract class BinaryOperatorExpr
    implements IExpr {
        protected final IExpr left;
        protected final IExpr right;

        public BinaryOperatorExpr(IExpr left, IExpr right) {
            this.left = left;
            this.right = right;
        }

        protected abstract IExpr create(IExpr var1, IExpr var2);

        protected abstract boolean evaluate(boolean var1, boolean var2);

        protected abstract IExpr fold(boolean var1, IExpr var2);

        protected abstract IExpr foldSameExpr(IExpr var1);

        protected abstract IExpr foldLessSpecific(IVar var1, IVar var2);

        @Override
        public final boolean evaluate(Map<String, String> vars) {
            return this.evaluate(this.left.evaluate(vars), this.right.evaluate(vars));
        }

        @Override
        public final IExpr rebind(Map<String, IExpr> vars) {
            return this.create(this.left.rebind(vars), this.right.rebind(vars));
        }

        @Override
        public final IExpr fold() {
            IExpr foldedLeft = this.left.fold();
            IExpr foldedRight = this.right.fold();
            Optional<Boolean> leftValue = foldedLeft.getConstantValue();
            Optional<Boolean> rightValue = foldedRight.getConstantValue();
            if (leftValue.isPresent()) {
                if (rightValue.isPresent()) {
                    return Evaluator.constant(this.evaluate((Boolean)leftValue.get(), (Boolean)rightValue.get()));
                }
                return this.fold((Boolean)leftValue.get(), foldedRight);
            }
            if (rightValue.isPresent()) {
                return this.fold((Boolean)rightValue.get(), foldedLeft);
            }
            if (foldedLeft.equals(foldedRight)) {
                return this.foldSameExpr(foldedLeft);
            }
            if (foldedLeft instanceof IVar && foldedRight instanceof IVar) {
                IVar leftVar = (IVar)foldedLeft;
                IVar rightVar = (IVar)foldedRight;
                if (leftVar.isLessSpecific(rightVar)) {
                    return this.foldLessSpecific(leftVar, rightVar);
                }
                if (rightVar.isLessSpecific(leftVar)) {
                    return this.foldLessSpecific(rightVar, leftVar);
                }
            }
            return this.create(foldedLeft, foldedRight);
        }

        @Override
        public Optional<Boolean> getConstantValue() {
            return Optional.absent();
        }

        @Override
        public boolean equals(IExpr other) {
            if (this == other) {
                return true;
            }
            if (other.getClass() == this.getClass()) {
                BinaryOperatorExpr otherOp = (BinaryOperatorExpr)other;
                return otherOp.left.equals(this.left) && otherOp.right.equals(this.right);
            }
            return false;
        }
    }

    private static class OperatorNot
    extends UnaryOperatorExpr
    implements NegatableOperator {
        private OperatorNot(IExpr value) {
            super(value);
        }

        @Override
        public boolean evaluate(Map<String, String> vars) {
            return !this.value.evaluate(vars);
        }

        @Override
        protected IExpr create(IExpr value) {
            return new OperatorNot(value);
        }

        @Override
        public IExpr fold() {
            IExpr foldedArg = this.value.fold();
            if (foldedArg instanceof NegatableOperator) {
                return ((NegatableOperator)((Object)foldedArg)).negation();
            }
            Optional<Boolean> argValue = foldedArg.getConstantValue();
            if (argValue.isPresent()) {
                return Evaluator.constant((Boolean)argValue.get() == false);
            }
            return this.create(foldedArg);
        }

        @Override
        public IExpr negation() {
            return this.value;
        }
    }

    private static interface NegatableOperator {
        public IExpr negation();
    }

    private static abstract class UnaryOperatorExpr
    implements IExpr {
        protected final IExpr value;

        private UnaryOperatorExpr(IExpr value) {
            this.value = value;
        }

        protected abstract IExpr create(IExpr var1);

        @Override
        public IExpr rebind(Map<String, IExpr> vars) {
            return this.create(this.value.rebind(vars));
        }

        @Override
        public Optional<Boolean> getConstantValue() {
            return Optional.absent();
        }

        @Override
        public boolean equals(IExpr other) {
            if (this == other) {
                return true;
            }
            if (other.getClass() == this.getClass()) {
                UnaryOperatorExpr otherOp = (UnaryOperatorExpr)other;
                return otherOp.value.equals(this.value);
            }
            return false;
        }
    }

    private static abstract class Constant
    implements IExpr {
        private Constant() {
        }

        protected abstract boolean value();

        @Override
        public boolean evaluate(Map<String, String> vars) {
            return this.value();
        }

        @Override
        public IExpr rebind(Map<String, IExpr> vars) {
            return this;
        }

        @Override
        public Optional<Boolean> getConstantValue() {
            return Optional.of((Object)this.value());
        }

        @Override
        public IExpr fold() {
            return this;
        }

        @Override
        public boolean equals(IExpr other) {
            return other == this;
        }
    }

    private static abstract class BinaryOperator
    extends Operator {
        public BinaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        public OperatorArity arity() {
            return OperatorArity.BINARY;
        }

        protected abstract IExpr createNode(IExpr var1, IExpr var2);

        @Override
        public IExpr createNode(List<IExpr> children) {
            Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Invalid arguments for binary operator %s", (Object[])new Object[]{this.id()});
            return this.createNode(children.get(0), children.get(1));
        }

        public boolean isLowerPriority(Operator other) {
            return this.precedence <= other.precedence;
        }
    }

    private static abstract class UnaryOperator
    extends Operator {
        public UnaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        public OperatorArity arity() {
            return OperatorArity.UNARY;
        }

        protected abstract IExpr createNode(IExpr var1);

        @Override
        public IExpr createNode(List<IExpr> children) {
            Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (String)"Invalid arguments for unary operator %s", (Object[])new Object[]{this.id()});
            return this.createNode(children.get(0));
        }

        public boolean isLowerPriority(Operator other) {
            return this.precedence < other.precedence;
        }
    }

    private static abstract class Operator
    implements IOperator<Operator> {
        private final String id;
        public final int precedence;

        public Operator(String id, int precedence) {
            this.id = id;
            this.precedence = precedence;
        }

        public abstract IExpr createNode(List<IExpr> var1);

        public String id() {
            return this.id;
        }
    }
}

