/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.relauncher.Side;
import openmods.OpenMods;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodEntry;
import openmods.network.rpc.MethodParamsCodec;
import openmods.network.rpc.RpcCall;
import openmods.network.rpc.TargetTypeProvider;
import openmods.utils.CommonRegistryCallbacks;

@ChannelHandler.Sharable
public class RpcCallCodec
extends MessageToMessageCodec<FMLProxyPacket, RpcCall> {
    private final IForgeRegistry<TargetTypeProvider> targetRegistry;
    private final IForgeRegistry<MethodEntry> methodRegistry;

    public RpcCallCodec(IForgeRegistry<TargetTypeProvider> targetRegistry, IForgeRegistry<MethodEntry> methodRegistry) {
        this.targetRegistry = targetRegistry;
        this.methodRegistry = methodRegistry;
    }

    protected void encode(ChannelHandlerContext ctx, RpcCall call, List<Object> out) throws Exception {
        PacketBuffer output = new PacketBuffer(Unpooled.buffer());
        IRpcTarget targetWrapper = call.target;
        int targetId = CommonRegistryCallbacks.mapObjectToId(this.targetRegistry, targetWrapper.getClass());
        output.func_150787_b(targetId);
        targetWrapper.writeToStream(output);
        BiMap<MethodEntry, Integer> eventIdMap = CommonRegistryCallbacks.getEntryIdMap(this.methodRegistry);
        int methodId = (Integer)eventIdMap.get((Object)call.method);
        output.func_150787_b(methodId);
        MethodParamsCodec paramsCodec = call.method.paramsCodec;
        paramsCodec.writeArgs(output, call.args);
        FMLProxyPacket packet = new FMLProxyPacket(output, "OpenMods|RPC");
        out.add(packet);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        PacketBuffer input = new PacketBuffer(msg.payload());
        Side side = (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get();
        int targetId = input.func_150792_a();
        BiMap idToEntryMap = CommonRegistryCallbacks.getEntryIdMap(this.targetRegistry).inverse();
        TargetTypeProvider entry = (TargetTypeProvider)idToEntryMap.get((Object)targetId);
        IRpcTarget target = entry.createRpcTarget();
        EntityPlayer player = this.getPlayer(msg);
        target.readFromStreamStream(side, player, input);
        BiMap<MethodEntry, Integer> eventIdMap = CommonRegistryCallbacks.getEntryIdMap(this.methodRegistry);
        int methodId = input.func_150792_a();
        MethodEntry method = (MethodEntry)eventIdMap.inverse().get((Object)methodId);
        Object[] args = method.paramsCodec.readArgs(input);
        int bufferJunkSize = input.readableBytes();
        Preconditions.checkState((bufferJunkSize == 0 ? 1 : 0) != 0, (String)"%s junk bytes left in buffer, method = %s", (Object[])new Object[]{bufferJunkSize, method});
        out.add(new RpcCall(target, method, args));
    }

    protected EntityPlayer getPlayer(FMLProxyPacket msg) {
        INetHandler handler = msg.handler();
        EntityPlayer player = OpenMods.proxy.getPlayerFromHandler(handler);
        Preconditions.checkNotNull((Object)player, (String)"Can't get player from handler %s", (Object[])new Object[]{handler});
        return player;
    }
}

