/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import java.lang.reflect.Method;
import openmods.datastore.DataStoreBuilder;
import openmods.network.IdSyncManager;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodIdRegistry;
import openmods.network.rpc.MethodParamsCodec;
import openmods.network.rpc.RpcIgnore;
import openmods.network.rpc.TargetWrapperRegistry;
import openmods.utils.io.TypeRW;
import org.objectweb.asm.Type;

public class RpcSetup {
    public static final String ID_FIELDS_SEPARATOR = ";";
    private int currentMethodId = 0;
    private int currentWrapperId = 0;
    private final DataStoreBuilder<String, Integer> methodsStoreBuilder = IdSyncManager.INSTANCE.createDataStore("rpc_methods", String.class, Integer.class);
    private final DataStoreBuilder<String, Integer> targetsStoreBuilder;

    RpcSetup() {
        this.methodsStoreBuilder.setDefaultKeyReaderWriter();
        this.methodsStoreBuilder.setValueReaderWriter(TypeRW.VLI_SERIALIZABLE);
        this.targetsStoreBuilder = IdSyncManager.INSTANCE.createDataStore("rpc_targets", String.class, Integer.class);
        this.targetsStoreBuilder.setDefaultKeyReaderWriter();
        this.targetsStoreBuilder.setValueReaderWriter(TypeRW.VLI_SERIALIZABLE);
    }

    public RpcSetup registerInterface(Class<?> intf) {
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.PREINITIALIZATION), (Object)"This method can only be called in pre-initialization state");
        Preconditions.checkArgument((boolean)intf.isInterface(), (String)"Class %s is not interface", (Object[])new Object[]{intf});
        for (Method m : intf.getMethods()) {
            if (m.isAnnotationPresent(RpcIgnore.class)) continue;
            Preconditions.checkArgument((m.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)"RPC methods cannot have return type (method = %s)", (Object[])new Object[]{m});
            MethodParamsCodec.create((Method)m).validate();
            String desc = Type.getMethodDescriptor((Method)m);
            String entry = m.getDeclaringClass().getName() + ID_FIELDS_SEPARATOR + m.getName() + ID_FIELDS_SEPARATOR + desc;
            if (this.methodsStoreBuilder.isRegistered(entry)) continue;
            this.methodsStoreBuilder.addEntry(entry, this.currentMethodId++);
        }
        return this;
    }

    public RpcSetup registerTargetWrapper(Class<? extends IRpcTarget> wrapperCls) {
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.PREINITIALIZATION), (Object)"This method can only be called in pre-initialization state");
        this.targetsStoreBuilder.addEntry(wrapperCls.getName(), this.currentWrapperId++);
        return this;
    }

    void finish(MethodIdRegistry methodRegistry, TargetWrapperRegistry wrapperRegistry) {
        this.methodsStoreBuilder.addVisitor(methodRegistry);
        this.methodsStoreBuilder.register();
        this.targetsStoreBuilder.addVisitor(wrapperRegistry);
        this.targetsStoreBuilder.register();
    }
}

