/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import openmods.block.OpenBlock;
import openmods.geometry.Orientation;
import openmods.renderer.IBlockRenderer;
import openmods.renderer.rotations.IRendererSetup;

public class RotatedBlockRenderer<T extends OpenBlock>
implements IBlockRenderer<T> {
    private final IBlockRenderer<T> wrapperRenderer;

    public RotatedBlockRenderer(IBlockRenderer<T> wrapperRenderer) {
        this.wrapperRenderer = wrapperRenderer;
    }

    @Override
    public void renderInventoryBlock(T block, int metadata, int modelID, RenderBlocks renderer) {
        Orientation orientation = block.getInventoryRenderOrientation();
        int renderMetadata = block.getInventoryRenderMetadata(metadata);
        IRendererSetup setup = ((OpenBlock)block).getRotationMode().getRenderSetup();
        RenderBlocks localRenderer = setup.enter(orientation, renderMetadata, renderer);
        this.wrapperRenderer.renderInventoryBlock(block, renderMetadata, modelID, localRenderer);
        setup.exit(localRenderer);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, T block, int modelId, RenderBlocks renderer) {
        int metadata = world.getBlockMetadata(x, y, z);
        Orientation orientation = block.getOrientation(metadata);
        IRendererSetup setup = ((OpenBlock)block).getRotationMode().getRenderSetup();
        RenderBlocks localRenderer = setup.enter(orientation, metadata, renderer);
        boolean wasRendered = this.wrapperRenderer.renderWorldBlock(world, x, y, z, block, modelId, localRenderer);
        setup.exit(localRenderer);
        return wasRendered;
    }

    public static <T extends OpenBlock> IBlockRenderer<T> wrap(IBlockRenderer<T> renderer) {
        return new RotatedBlockRenderer<T>(renderer);
    }
}

